/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeInternetGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInternetGatewaysRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeInternetGatewaysRequest.Builder, DescribeInternetGatewaysRequest> {
    private final List<Filter> filters;

    private final List<String> internetGatewayIds;

    private DescribeInternetGatewaysRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.internetGatewayIds = builder.internetGatewayIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (
     * <code>available</code>). Present only if a VPC is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.vpc-id</code> - The ID of an attached VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>internet-gateway-id</code> - The ID of the Internet gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (
     *         <code>available</code>). Present only if a VPC is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.vpc-id</code> - The ID of an attached VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>internet-gateway-id</code> - The ID of the Internet gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more Internet gateway IDs.
     * </p>
     * <p>
     * Default: Describes all your Internet gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Internet gateway IDs.</p>
     *         <p>
     *         Default: Describes all your Internet gateways.
     */
    public List<String> internetGatewayIds() {
        return internetGatewayIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((internetGatewayIds() == null) ? 0 : internetGatewayIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInternetGatewaysRequest)) {
            return false;
        }
        DescribeInternetGatewaysRequest other = (DescribeInternetGatewaysRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.internetGatewayIds() == null ^ this.internetGatewayIds() == null) {
            return false;
        }
        if (other.internetGatewayIds() != null && !other.internetGatewayIds().equals(this.internetGatewayIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (internetGatewayIds() != null) {
            sb.append("InternetGatewayIds: ").append(internetGatewayIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInternetGatewaysRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (
         * <code>available</code>). Present only if a VPC is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.vpc-id</code> - The ID of an attached VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>internet-gateway-id</code> - The ID of the Internet gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (
         *        <code>available</code>). Present only if a VPC is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.vpc-id</code> - The ID of an attached VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>internet-gateway-id</code> - The ID of the Internet gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (
         * <code>available</code>). Present only if a VPC is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.vpc-id</code> - The ID of an attached VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>internet-gateway-id</code> - The ID of the Internet gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (
         *        <code>available</code>). Present only if a VPC is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.vpc-id</code> - The ID of an attached VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>internet-gateway-id</code> - The ID of the Internet gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more Internet gateway IDs.
         * </p>
         * <p>
         * Default: Describes all your Internet gateways.
         * </p>
         * 
         * @param internetGatewayIds
         *        One or more Internet gateway IDs.</p>
         *        <p>
         *        Default: Describes all your Internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayIds(Collection<String> internetGatewayIds);

        /**
         * <p>
         * One or more Internet gateway IDs.
         * </p>
         * <p>
         * Default: Describes all your Internet gateways.
         * </p>
         * 
         * @param internetGatewayIds
         *        One or more Internet gateway IDs.</p>
         *        <p>
         *        Default: Describes all your Internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayIds(String... internetGatewayIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> internetGatewayIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInternetGatewaysRequest model) {
            setFilters(model.filters);
            setInternetGatewayIds(model.internetGatewayIds);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getInternetGatewayIds() {
            return internetGatewayIds;
        }

        @Override
        public final Builder internetGatewayIds(Collection<String> internetGatewayIds) {
            this.internetGatewayIds = ValueStringListCopier.copy(internetGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGatewayIds(String... internetGatewayIds) {
            internetGatewayIds(Arrays.asList(internetGatewayIds));
            return this;
        }

        public final void setInternetGatewayIds(Collection<String> internetGatewayIds) {
            this.internetGatewayIds = ValueStringListCopier.copy(internetGatewayIds);
        }

        @Override
        public DescribeInternetGatewaysRequest build() {
            return new DescribeInternetGatewaysRequest(this);
        }
    }
}
