/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeNetworkInterfaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNetworkInterfacesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeNetworkInterfacesRequest.Builder, DescribeNetworkInterfacesRequest> {
    private final List<Filter> filters;

    private final List<String> networkInterfaceIds;

    private DescribeNetworkInterfacesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.networkInterfaceIds = builder.networkInterfaceIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
     * associated with the Elastic IP address (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.association-id</code> - The association ID returned when the network interface was associated
     * with an IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
     * (IPv4) for your network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.attachment-id</code> - The ID of the interface attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance is
     * terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.device-index</code> - The device index to which the network interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> |
     * <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>description</code> - The description of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-name</code> - The name of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mac-address</code> - The MAC address of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the network interface owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
     * Management Console, Auto Scaling, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service (for
     * example, AWS Management Console, Auto Scaling, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source-desk-check</code> - Indicates whether the network interface performs source/destination checking. A
     * value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The
     * value must be <code>false</code> for the network interface to perform network address translation (NAT) in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the network interface. If the network interface is not attached to an
     * instance, the status is <code>available</code>; if a network interface is attached to an instance the status is
     * <code>in-use</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the network interface.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
     *         with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
     *         associated with the Elastic IP address (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.association-id</code> - The association ID returned when the network interface was
     *         associated with an IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
     *         address (IPv4) for your network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
     *         network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.attachment-id</code> - The ID of the interface attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
     *         instance is terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.device-index</code> - The device index to which the network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface
     *         is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
     *         attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>description</code> - The description of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of a security group associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of a security group associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mac-address</code> - The MAC address of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the network interface owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example,
     *         AWS Management Console, Auto Scaling, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS
     *         service (for example, AWS Management Console, Auto Scaling, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
     *         checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking
     *         is disabled. The value must be <code>false</code> for the network interface to perform network address
     *         translation (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the network interface. If the network interface is not attached to an
     *         instance, the status is <code>available</code>; if a network interface is attached to an instance the
     *         status is <code>in-use</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the network interface.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more network interface IDs.
     * </p>
     * <p>
     * Default: Describes all your network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network interface IDs.</p>
     *         <p>
     *         Default: Describes all your network interfaces.
     */
    public List<String> networkInterfaceIds() {
        return networkInterfaceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceIds() == null) ? 0 : networkInterfaceIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacesRequest)) {
            return false;
        }
        DescribeNetworkInterfacesRequest other = (DescribeNetworkInterfacesRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.networkInterfaceIds() == null ^ this.networkInterfaceIds() == null) {
            return false;
        }
        if (other.networkInterfaceIds() != null && !other.networkInterfaceIds().equals(this.networkInterfaceIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (networkInterfaceIds() != null) {
            sb.append("NetworkInterfaceIds: ").append(networkInterfaceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeNetworkInterfacesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
         * associated with the Elastic IP address (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.association-id</code> - The association ID returned when the network interface was
         * associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
         * (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance
         * is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device-index</code> - The device index to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code>
         * | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the network interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service
         * (for example, AWS Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the network interface. If the network interface is not attached to an
         * instance, the status is <code>available</code>; if a network interface is attached to an instance the status
         * is <code>in-use</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
         *        with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.public-ip</code> - The association ID returned when the network interface
         *        was associated with the Elastic IP address (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.association-id</code> - The association ID returned when the network interface was
         *        associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
         *        address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
         *        instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device-index</code> - The device index to which the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the network interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS
         *        service (for example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         *        checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means
         *        checking is disabled. The value must be <code>false</code> for the network interface to perform
         *        network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the network interface. If the network interface is not attached to
         *        an instance, the status is <code>available</code>; if a network interface is attached to an instance
         *        the status is <code>in-use</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
         * associated with the Elastic IP address (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.association-id</code> - The association ID returned when the network interface was
         * associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
         * (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance
         * is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device-index</code> - The device index to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code>
         * | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the network interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service
         * (for example, AWS Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the network interface. If the network interface is not attached to an
         * instance, the status is <code>available</code>; if a network interface is attached to an instance the status
         * is <code>in-use</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
         *        with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.public-ip</code> - The association ID returned when the network interface
         *        was associated with the Elastic IP address (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.association-id</code> - The association ID returned when the network interface was
         *        associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
         *        address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
         *        instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device-index</code> - The device index to which the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the network interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS
         *        service (for example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         *        checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means
         *        checking is disabled. The value must be <code>false</code> for the network interface to perform
         *        network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the network interface. If the network interface is not attached to
         *        an instance, the status is <code>available</code>; if a network interface is attached to an instance
         *        the status is <code>in-use</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more network interface IDs.
         * </p>
         * <p>
         * Default: Describes all your network interfaces.
         * </p>
         * 
         * @param networkInterfaceIds
         *        One or more network interface IDs.</p>
         *        <p>
         *        Default: Describes all your network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(Collection<String> networkInterfaceIds);

        /**
         * <p>
         * One or more network interface IDs.
         * </p>
         * <p>
         * Default: Describes all your network interfaces.
         * </p>
         * 
         * @param networkInterfaceIds
         *        One or more network interface IDs.</p>
         *        <p>
         *        Default: Describes all your network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(String... networkInterfaceIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> networkInterfaceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacesRequest model) {
            setFilters(model.filters);
            setNetworkInterfaceIds(model.networkInterfaceIds);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getNetworkInterfaceIds() {
            return networkInterfaceIds;
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String... networkInterfaceIds) {
            networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdListCopier.copy(networkInterfaceIds);
        }

        @Override
        public DescribeNetworkInterfacesRequest build() {
            return new DescribeNetworkInterfacesRequest(this);
        }
    }
}
