/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeScheduledInstanceAvailability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScheduledInstanceAvailabilityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeScheduledInstanceAvailabilityRequest.Builder, DescribeScheduledInstanceAvailabilityRequest> {
    private final List<Filter> filters;

    private final SlotDateTimeRangeRequest firstSlotStartTimeRange;

    private final Integer maxResults;

    private final Integer maxSlotDurationInHours;

    private final Integer minSlotDurationInHours;

    private final String nextToken;

    private final ScheduledInstanceRecurrenceRequest recurrence;

    private DescribeScheduledInstanceAvailabilityRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.firstSlotStartTimeRange = builder.firstSlotStartTimeRange;
        this.maxResults = builder.maxResults;
        this.maxSlotDurationInHours = builder.maxSlotDurationInHours;
        this.minSlotDurationInHours = builder.minSlotDurationInHours;
        this.nextToken = builder.nextToken;
        this.recurrence = builder.recurrence;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The time period for the first schedule to start.
     * </p>
     * 
     * @return The time period for the first schedule to start.
     */
    public SlotDateTimeRangeRequest firstSlotStartTimeRange() {
        return firstSlotStartTimeRange;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. This value can be between 5 and 300. The default value
     * is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. This value can be between 5 and 300. The
     *         default value is 300. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code> and
     * less than 1,720.
     * </p>
     * 
     * @return The maximum available duration, in hours. This value must be greater than
     *         <code>MinSlotDurationInHours</code> and less than 1,720.
     */
    public Integer maxSlotDurationInHours() {
        return maxSlotDurationInHours;
    }

    /**
     * <p>
     * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the
     * minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is
     * 100 hours.
     * </p>
     * 
     * @return The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For
     *         example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum
     *         monthly schedule is 100 hours.
     */
    public Integer minSlotDurationInHours() {
        return minSlotDurationInHours;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The schedule recurrence.
     * </p>
     * 
     * @return The schedule recurrence.
     */
    public ScheduledInstanceRecurrenceRequest recurrence() {
        return recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((firstSlotStartTimeRange() == null) ? 0 : firstSlotStartTimeRange().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((maxSlotDurationInHours() == null) ? 0 : maxSlotDurationInHours().hashCode());
        hashCode = 31 * hashCode + ((minSlotDurationInHours() == null) ? 0 : minSlotDurationInHours().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((recurrence() == null) ? 0 : recurrence().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityRequest)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityRequest other = (DescribeScheduledInstanceAvailabilityRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.firstSlotStartTimeRange() == null ^ this.firstSlotStartTimeRange() == null) {
            return false;
        }
        if (other.firstSlotStartTimeRange() != null && !other.firstSlotStartTimeRange().equals(this.firstSlotStartTimeRange())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.maxSlotDurationInHours() == null ^ this.maxSlotDurationInHours() == null) {
            return false;
        }
        if (other.maxSlotDurationInHours() != null && !other.maxSlotDurationInHours().equals(this.maxSlotDurationInHours())) {
            return false;
        }
        if (other.minSlotDurationInHours() == null ^ this.minSlotDurationInHours() == null) {
            return false;
        }
        if (other.minSlotDurationInHours() != null && !other.minSlotDurationInHours().equals(this.minSlotDurationInHours())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.recurrence() == null ^ this.recurrence() == null) {
            return false;
        }
        if (other.recurrence() != null && !other.recurrence().equals(this.recurrence())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (firstSlotStartTimeRange() != null) {
            sb.append("FirstSlotStartTimeRange: ").append(firstSlotStartTimeRange()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (maxSlotDurationInHours() != null) {
            sb.append("MaxSlotDurationInHours: ").append(maxSlotDurationInHours()).append(",");
        }
        if (minSlotDurationInHours() != null) {
            sb.append("MinSlotDurationInHours: ").append(minSlotDurationInHours()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (recurrence() != null) {
            sb.append("Recurrence: ").append(recurrence()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * 
         * @param firstSlotStartTimeRange
         *        The time period for the first schedule to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange);

        /**
         * <p>
         * The maximum number of results to return in a single call. This value can be between 5 and 300. The default
         * value is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. This value can be between 5 and 300. The
         *        default value is 300. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code>
         * and less than 1,720.
         * </p>
         * 
         * @param maxSlotDurationInHours
         *        The maximum available duration, in hours. This value must be greater than
         *        <code>MinSlotDurationInHours</code> and less than 1,720.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSlotDurationInHours(Integer maxSlotDurationInHours);

        /**
         * <p>
         * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example,
         * the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly
         * schedule is 100 hours.
         * </p>
         * 
         * @param minSlotDurationInHours
         *        The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For
         *        example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the
         *        minimum monthly schedule is 100 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSlotDurationInHours(Integer minSlotDurationInHours);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * 
         * @param recurrence
         *        The schedule recurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private SlotDateTimeRangeRequest firstSlotStartTimeRange;

        private Integer maxResults;

        private Integer maxSlotDurationInHours;

        private Integer minSlotDurationInHours;

        private String nextToken;

        private ScheduledInstanceRecurrenceRequest recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityRequest model) {
            setFilters(model.filters);
            setFirstSlotStartTimeRange(model.firstSlotStartTimeRange);
            setMaxResults(model.maxResults);
            setMaxSlotDurationInHours(model.maxSlotDurationInHours);
            setMinSlotDurationInHours(model.minSlotDurationInHours);
            setNextToken(model.nextToken);
            setRecurrence(model.recurrence);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final SlotDateTimeRangeRequest getFirstSlotStartTimeRange() {
            return firstSlotStartTimeRange;
        }

        @Override
        public final Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange;
            return this;
        }

        public final void setFirstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMaxSlotDurationInHours() {
            return maxSlotDurationInHours;
        }

        @Override
        public final Builder maxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
            return this;
        }

        public final void setMaxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
        }

        public final Integer getMinSlotDurationInHours() {
            return minSlotDurationInHours;
        }

        @Override
        public final Builder minSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
            return this;
        }

        public final void setMinSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ScheduledInstanceRecurrenceRequest getRecurrence() {
            return recurrence;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrenceRequest recurrence) {
            this.recurrence = recurrence;
        }

        @Override
        public DescribeScheduledInstanceAvailabilityRequest build() {
            return new DescribeScheduledInstanceAvailabilityRequest(this);
        }
    }
}
