/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScheduledInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeScheduledInstancesRequest.Builder, DescribeScheduledInstancesRequest> {
    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> scheduledInstanceIds;

    private final SlotStartTimeRangeRequest slotStartTimeRange;

    private DescribeScheduledInstancesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scheduledInstanceIds = builder.scheduledInstanceIds;
        this.slotStartTimeRange = builder.slotStartTimeRange;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. This value can be between 5 and 300. The default value
     * is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. This value can be between 5 and 300. The
     *         default value is 100. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * One or more Scheduled Instance IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Scheduled Instance IDs.
     */
    public List<String> scheduledInstanceIds() {
        return scheduledInstanceIds;
    }

    /**
     * <p>
     * The time period for the first schedule to start.
     * </p>
     * 
     * @return The time period for the first schedule to start.
     */
    public SlotStartTimeRangeRequest slotStartTimeRange() {
        return slotStartTimeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((scheduledInstanceIds() == null) ? 0 : scheduledInstanceIds().hashCode());
        hashCode = 31 * hashCode + ((slotStartTimeRange() == null) ? 0 : slotStartTimeRange().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesRequest)) {
            return false;
        }
        DescribeScheduledInstancesRequest other = (DescribeScheduledInstancesRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.scheduledInstanceIds() == null ^ this.scheduledInstanceIds() == null) {
            return false;
        }
        if (other.scheduledInstanceIds() != null && !other.scheduledInstanceIds().equals(this.scheduledInstanceIds())) {
            return false;
        }
        if (other.slotStartTimeRange() == null ^ this.slotStartTimeRange() == null) {
            return false;
        }
        if (other.slotStartTimeRange() != null && !other.slotStartTimeRange().equals(this.slotStartTimeRange())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (scheduledInstanceIds() != null) {
            sb.append("ScheduledInstanceIds: ").append(scheduledInstanceIds()).append(",");
        }
        if (slotStartTimeRange() != null) {
            sb.append("SlotStartTimeRange: ").append(slotStartTimeRange()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeScheduledInstancesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of results to return in a single call. This value can be between 5 and 300. The default
         * value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. This value can be between 5 and 300. The
         *        default value is 100. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * One or more Scheduled Instance IDs.
         * </p>
         * 
         * @param scheduledInstanceIds
         *        One or more Scheduled Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceIds(Collection<String> scheduledInstanceIds);

        /**
         * <p>
         * One or more Scheduled Instance IDs.
         * </p>
         * 
         * @param scheduledInstanceIds
         *        One or more Scheduled Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceIds(String... scheduledInstanceIds);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * 
         * @param slotStartTimeRange
         *        The time period for the first schedule to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private List<String> scheduledInstanceIds;

        private SlotStartTimeRangeRequest slotStartTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstancesRequest model) {
            setFilters(model.filters);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
            setScheduledInstanceIds(model.scheduledInstanceIds);
            setSlotStartTimeRange(model.slotStartTimeRange);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getScheduledInstanceIds() {
            return scheduledInstanceIds;
        }

        @Override
        public final Builder scheduledInstanceIds(Collection<String> scheduledInstanceIds) {
            this.scheduledInstanceIds = ScheduledInstanceIdRequestSetCopier.copy(scheduledInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceIds(String... scheduledInstanceIds) {
            scheduledInstanceIds(Arrays.asList(scheduledInstanceIds));
            return this;
        }

        public final void setScheduledInstanceIds(Collection<String> scheduledInstanceIds) {
            this.scheduledInstanceIds = ScheduledInstanceIdRequestSetCopier.copy(scheduledInstanceIds);
        }

        public final SlotStartTimeRangeRequest getSlotStartTimeRange() {
            return slotStartTimeRange;
        }

        @Override
        public final Builder slotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
            this.slotStartTimeRange = slotStartTimeRange;
            return this;
        }

        public final void setSlotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
            this.slotStartTimeRange = slotStartTimeRange;
        }

        @Override
        public DescribeScheduledInstancesRequest build() {
            return new DescribeScheduledInstancesRequest(this);
        }
    }
}
