/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSnapshots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSnapshotsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSnapshotsResponse.Builder, DescribeSnapshotsResponse> {
    private final List<Snapshot> snapshots;

    private final String nextToken;

    private DescribeSnapshotsResponse(BuilderImpl builder) {
        this.snapshots = builder.snapshots;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the snapshots.
     */
    public List<Snapshot> snapshots() {
        return snapshots;
    }

    /**
     * <p>
     * The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When the results
     * of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can be used to retrieve
     * the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When the
     *         results of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can be
     *         used to retrieve the next page of results. This value is <code>null</code> when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((snapshots() == null) ? 0 : snapshots().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResponse)) {
            return false;
        }
        DescribeSnapshotsResponse other = (DescribeSnapshotsResponse) obj;
        if (other.snapshots() == null ^ this.snapshots() == null) {
            return false;
        }
        if (other.snapshots() != null && !other.snapshots().equals(this.snapshots())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (snapshots() != null) {
            sb.append("Snapshots: ").append(snapshots()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSnapshotsResponse> {
        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshots
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Collection<Snapshot> snapshots);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshots
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Snapshot... snapshots);

        /**
         * <p>
         * The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When the
         * results of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can be used to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When
         *        the results of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can
         *        be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Snapshot> snapshots;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsResponse model) {
            setSnapshots(model.snapshots);
            setNextToken(model.nextToken);
        }

        public final Collection<Snapshot> getSnapshots() {
            return snapshots;
        }

        @Override
        public final Builder snapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Snapshot... snapshots) {
            snapshots(Arrays.asList(snapshots));
            return this;
        }

        public final void setSnapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotListCopier.copy(snapshots);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSnapshotsResponse build() {
            return new DescribeSnapshotsResponse(this);
        }
    }
}
