/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVolumeAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumeAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeVolumeAttributeRequest.Builder, DescribeVolumeAttributeRequest> {
    private final String attribute;

    private final String volumeId;

    private DescribeVolumeAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The attribute of the volume. This parameter is required.
     * </p>
     * 
     * @return The attribute of the volume. This parameter is required.
     * @see VolumeAttributeName
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((volumeId() == null) ? 0 : volumeId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeAttributeRequest)) {
            return false;
        }
        DescribeVolumeAttributeRequest other = (DescribeVolumeAttributeRequest) obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVolumeAttributeRequest> {
        /**
         * <p>
         * The attribute of the volume. This parameter is required.
         * </p>
         * 
         * @param attribute
         *        The attribute of the volume. This parameter is required.
         * @see VolumeAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute of the volume. This parameter is required.
         * </p>
         * 
         * @param attribute
         *        The attribute of the volume. This parameter is required.
         * @see VolumeAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttributeName
         */
        Builder attribute(VolumeAttributeName attribute);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);
    }

    private static final class BuilderImpl implements Builder {
        private String attribute;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeAttributeRequest model) {
            setAttribute(model.attribute);
            setVolumeId(model.volumeId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(VolumeAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public DescribeVolumeAttributeRequest build() {
            return new DescribeVolumeAttributeRequest(this);
        }
    }
}
