/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVolumes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeVolumesRequest.Builder, DescribeVolumesRequest> {
    private final List<Filter> filters;

    private final List<String> volumeIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeVolumesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.volumeIds = builder.volumeIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.device</code> - The device name that is exposed to the instance (for example,
     * <code>/dev/sda1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
     * <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone in which the volume was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>create-time</code> - The time stamp when the volume was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>encrypted</code> - The encryption status of the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>size</code> - The size of the volume, in GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>snapshot-id</code> - The snapshot from which the volume was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
     * <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-id</code> - The volume ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD,
     * <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for
     * Cold HDD, or <code>standard</code> for Magnetic volumes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.device</code> - The device name that is exposed to the instance (for example,
     *         <code>/dev/sda1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
     *         <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone in which the volume was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>create-time</code> - The time stamp when the volume was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>encrypted</code> - The encryption status of the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>size</code> - The size of the volume, in GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>snapshot-id</code> - The snapshot from which the volume was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
     *         <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-id</code> - The volume ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose
     *         SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
     *         <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more volume IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more volume IDs.
     */
    public List<String> volumeIds() {
        return volumeIds;
    }

    /**
     * <p>
     * The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When this
     * parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a single page
     * along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>DescribeVolumes</code> request with the returned <code>NextToken</code> value. This value
     * can be between 5 and 500; if <code>MaxResults</code> is given a value larger than 500, only 500 results are
     * returned. If this parameter is not used, then <code>DescribeVolumes</code> returns all results. You cannot
     * specify this parameter and the volume IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When
     *         this parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a
     *         single page along with a <code>NextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>DescribeVolumes</code> request with the returned
     *         <code>NextToken</code> value. This value can be between 5 and 500; if <code>MaxResults</code> is given a
     *         value larger than 500, only 500 results are returned. If this parameter is not used, then
     *         <code>DescribeVolumes</code> returns all results. You cannot specify this parameter and the volume IDs
     *         parameter in the same request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code> request where
     * <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code> request
     *         where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>NextToken</code> value. This value
     *         is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((volumeIds() == null) ? 0 : volumeIds().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesRequest)) {
            return false;
        }
        DescribeVolumesRequest other = (DescribeVolumesRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.volumeIds() == null ^ this.volumeIds() == null) {
            return false;
        }
        if (other.volumeIds() != null && !other.volumeIds().equals(this.volumeIds())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (volumeIds() != null) {
            sb.append("VolumeIds: ").append(volumeIds()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVolumesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device</code> - The device name that is exposed to the instance (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
         * <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>encrypted</code> - The encryption status of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot from which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         * <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The volume ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD,
         * <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code>
         * for Cold HDD, or <code>standard</code> for Magnetic volumes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device</code> - The device name that is exposed to the instance (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code>
         *        | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time stamp when the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>encrypted</code> - The encryption status of the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot from which the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         *        <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The volume ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General
         *        Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
         *        <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device</code> - The device name that is exposed to the instance (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
         * <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>encrypted</code> - The encryption status of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot from which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         * <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The volume ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD,
         * <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code>
         * for Cold HDD, or <code>standard</code> for Magnetic volumes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device</code> - The device name that is exposed to the instance (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code>
         *        | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time stamp when the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>encrypted</code> - The encryption status of the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot from which the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         *        <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The volume ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General
         *        Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
         *        <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more volume IDs.
         * </p>
         * 
         * @param volumeIds
         *        One or more volume IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * One or more volume IDs.
         * </p>
         * 
         * @param volumeIds
         *        One or more volume IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);

        /**
         * <p>
         * The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When this
         * parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a single page
         * along with a <code>NextToken</code> response element. The remaining results of the initial request can be
         * seen by sending another <code>DescribeVolumes</code> request with the returned <code>NextToken</code> value.
         * This value can be between 5 and 500; if <code>MaxResults</code> is given a value larger than 500, only 500
         * results are returned. If this parameter is not used, then <code>DescribeVolumes</code> returns all results.
         * You cannot specify this parameter and the volume IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output.
         *        When this parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results
         *        in a single page along with a <code>NextToken</code> response element. The remaining results of the
         *        initial request can be seen by sending another <code>DescribeVolumes</code> request with the returned
         *        <code>NextToken</code> value. This value can be between 5 and 500; if <code>MaxResults</code> is given
         *        a value larger than 500, only 500 results are returned. If this parameter is not used, then
         *        <code>DescribeVolumes</code> returns all results. You cannot specify this parameter and the volume IDs
         *        parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code> request
         * where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>NextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code>
         *        request where <code>MaxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>NextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> volumeIds;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesRequest model) {
            setFilters(model.filters);
            setVolumeIds(model.volumeIds);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getVolumeIds() {
            return volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVolumesRequest build() {
            return new DescribeVolumesRequest(this);
        }
    }
}
