/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpnGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpnGatewaysResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVpnGatewaysResponse.Builder, DescribeVpnGatewaysResponse> {
    private final List<VpnGateway> vpnGateways;

    private DescribeVpnGatewaysResponse(BuilderImpl builder) {
        this.vpnGateways = builder.vpnGateways;
    }

    /**
     * <p>
     * Information about one or more virtual private gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more virtual private gateways.
     */
    public List<VpnGateway> vpnGateways() {
        return vpnGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpnGateways() == null) ? 0 : vpnGateways().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnGatewaysResponse)) {
            return false;
        }
        DescribeVpnGatewaysResponse other = (DescribeVpnGatewaysResponse) obj;
        if (other.vpnGateways() == null ^ this.vpnGateways() == null) {
            return false;
        }
        if (other.vpnGateways() != null && !other.vpnGateways().equals(this.vpnGateways())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpnGateways() != null) {
            sb.append("VpnGateways: ").append(vpnGateways()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpnGatewaysResponse> {
        /**
         * <p>
         * Information about one or more virtual private gateways.
         * </p>
         * 
         * @param vpnGateways
         *        Information about one or more virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateways(Collection<VpnGateway> vpnGateways);

        /**
         * <p>
         * Information about one or more virtual private gateways.
         * </p>
         * 
         * @param vpnGateways
         *        Information about one or more virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateways(VpnGateway... vpnGateways);
    }

    private static final class BuilderImpl implements Builder {
        private List<VpnGateway> vpnGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnGatewaysResponse model) {
            setVpnGateways(model.vpnGateways);
        }

        public final Collection<VpnGateway> getVpnGateways() {
            return vpnGateways;
        }

        @Override
        public final Builder vpnGateways(Collection<VpnGateway> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copy(vpnGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGateways(VpnGateway... vpnGateways) {
            vpnGateways(Arrays.asList(vpnGateways));
            return this;
        }

        public final void setVpnGateways(Collection<VpnGateway> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copy(vpnGateways);
        }

        @Override
        public DescribeVpnGatewaysResponse build() {
            return new DescribeVpnGatewaysResponse(this);
        }
    }
}
