/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a set of DHCP options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DhcpOptions implements ToCopyableBuilder<DhcpOptions.Builder, DhcpOptions> {
    private final List<DhcpConfiguration> dhcpConfigurations;

    private final String dhcpOptionsId;

    private final List<Tag> tags;

    private DhcpOptions(BuilderImpl builder) {
        this.dhcpConfigurations = builder.dhcpConfigurations;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * One or more DHCP options in the set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more DHCP options in the set.
     */
    public List<DhcpConfiguration> dhcpConfigurations() {
        return dhcpConfigurations;
    }

    /**
     * <p>
     * The ID of the set of DHCP options.
     * </p>
     * 
     * @return The ID of the set of DHCP options.
     */
    public String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    /**
     * <p>
     * Any tags assigned to the DHCP options set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the DHCP options set.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dhcpConfigurations() == null) ? 0 : dhcpConfigurations().hashCode());
        hashCode = 31 * hashCode + ((dhcpOptionsId() == null) ? 0 : dhcpOptionsId().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions) obj;
        if (other.dhcpConfigurations() == null ^ this.dhcpConfigurations() == null) {
            return false;
        }
        if (other.dhcpConfigurations() != null && !other.dhcpConfigurations().equals(this.dhcpConfigurations())) {
            return false;
        }
        if (other.dhcpOptionsId() == null ^ this.dhcpOptionsId() == null) {
            return false;
        }
        if (other.dhcpOptionsId() != null && !other.dhcpOptionsId().equals(this.dhcpOptionsId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dhcpConfigurations() != null) {
            sb.append("DhcpConfigurations: ").append(dhcpConfigurations()).append(",");
        }
        if (dhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: ").append(dhcpOptionsId()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DhcpOptions> {
        /**
         * <p>
         * One or more DHCP options in the set.
         * </p>
         * 
         * @param dhcpConfigurations
         *        One or more DHCP options in the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations);

        /**
         * <p>
         * One or more DHCP options in the set.
         * </p>
         * 
         * @param dhcpConfigurations
         *        One or more DHCP options in the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(DhcpConfiguration... dhcpConfigurations);

        /**
         * <p>
         * The ID of the set of DHCP options.
         * </p>
         * 
         * @param dhcpOptionsId
         *        The ID of the set of DHCP options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);

        /**
         * <p>
         * Any tags assigned to the DHCP options set.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the DHCP options set.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private List<DhcpConfiguration> dhcpConfigurations;

        private String dhcpOptionsId;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DhcpOptions model) {
            setDhcpConfigurations(model.dhcpConfigurations);
            setDhcpOptionsId(model.dhcpOptionsId);
            setTags(model.tags);
        }

        public final Collection<DhcpConfiguration> getDhcpConfigurations() {
            return dhcpConfigurations;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration... dhcpConfigurations) {
            dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copy(dhcpConfigurations);
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        public DhcpOptions build() {
            return new DhcpOptions(this);
        }
    }
}
