/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHostReservationPurchasePreviewResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetHostReservationPurchasePreviewResponse.Builder, GetHostReservationPurchasePreviewResponse> {
    private final String currencyCode;

    private final List<Purchase> purchase;

    private final String totalHourlyPrice;

    private final String totalUpfrontPrice;

    private GetHostReservationPurchasePreviewResponse(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified.
     * At this time, the only supported currency is <code>USD</code>.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
     *         specified. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
     */
    public List<Purchase> purchase() {
        return purchase;
    }

    /**
     * <p>
     * The potential total hourly price of the reservation per hour.
     * </p>
     * 
     * @return The potential total hourly price of the reservation per hour.
     */
    public String totalHourlyPrice() {
        return totalHourlyPrice;
    }

    /**
     * <p>
     * The potential total upfront price. This is billed immediately.
     * </p>
     * 
     * @return The potential total upfront price. This is billed immediately.
     */
    public String totalUpfrontPrice() {
        return totalUpfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((currencyCode() == null) ? 0 : currencyCode().hashCode());
        hashCode = 31 * hashCode + ((purchase() == null) ? 0 : purchase().hashCode());
        hashCode = 31 * hashCode + ((totalHourlyPrice() == null) ? 0 : totalHourlyPrice().hashCode());
        hashCode = 31 * hashCode + ((totalUpfrontPrice() == null) ? 0 : totalUpfrontPrice().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewResponse)) {
            return false;
        }
        GetHostReservationPurchasePreviewResponse other = (GetHostReservationPurchasePreviewResponse) obj;
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.purchase() == null ^ this.purchase() == null) {
            return false;
        }
        if (other.purchase() != null && !other.purchase().equals(this.purchase())) {
            return false;
        }
        if (other.totalHourlyPrice() == null ^ this.totalHourlyPrice() == null) {
            return false;
        }
        if (other.totalHourlyPrice() != null && !other.totalHourlyPrice().equals(this.totalHourlyPrice())) {
            return false;
        }
        if (other.totalUpfrontPrice() == null ^ this.totalUpfrontPrice() == null) {
            return false;
        }
        if (other.totalUpfrontPrice() != null && !other.totalUpfrontPrice().equals(this.totalUpfrontPrice())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (currencyCode() != null) {
            sb.append("CurrencyCode: ").append(currencyCode()).append(",");
        }
        if (purchase() != null) {
            sb.append("Purchase: ").append(purchase()).append(",");
        }
        if (totalHourlyPrice() != null) {
            sb.append("TotalHourlyPrice: ").append(totalHourlyPrice()).append(",");
        }
        if (totalUpfrontPrice() != null) {
            sb.append("TotalUpfrontPrice: ").append(totalUpfrontPrice()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetHostReservationPurchasePreviewResponse> {
        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         * specified. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         * specified. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * </p>
         * 
         * @param purchase
         *        The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchase(Collection<Purchase> purchase);

        /**
         * <p>
         * The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * </p>
         * 
         * @param purchase
         *        The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchase(Purchase... purchase);

        /**
         * <p>
         * The potential total hourly price of the reservation per hour.
         * </p>
         * 
         * @param totalHourlyPrice
         *        The potential total hourly price of the reservation per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalHourlyPrice(String totalHourlyPrice);

        /**
         * <p>
         * The potential total upfront price. This is billed immediately.
         * </p>
         * 
         * @param totalUpfrontPrice
         *        The potential total upfront price. This is billed immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalUpfrontPrice(String totalUpfrontPrice);
    }

    private static final class BuilderImpl implements Builder {
        private String currencyCode;

        private List<Purchase> purchase;

        private String totalHourlyPrice;

        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewResponse model) {
            setCurrencyCode(model.currencyCode);
            setPurchase(model.purchase);
            setTotalHourlyPrice(model.totalHourlyPrice);
            setTotalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<Purchase> getPurchase() {
            return purchase;
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase... purchase) {
            purchase(Arrays.asList(purchase));
            return this;
        }

        public final void setPurchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
        }

        public final String getTotalHourlyPrice() {
            return totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        public final String getTotalUpfrontPrice() {
            return totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        @Override
        public GetHostReservationPurchasePreviewResponse build() {
            return new GetHostReservationPurchasePreviewResponse(this);
        }
    }
}
