/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ImportInstance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ImportInstanceRequest.Builder, ImportInstanceRequest> {
    private final String description;

    private final List<DiskImage> diskImages;

    private final ImportInstanceLaunchSpecification launchSpecification;

    private final String platform;

    private ImportInstanceRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.diskImages = builder.diskImages;
        this.launchSpecification = builder.launchSpecification;
        this.platform = builder.platform;
    }

    /**
     * <p>
     * A description for the instance being imported.
     * </p>
     * 
     * @return A description for the instance being imported.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The disk image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The disk image.
     */
    public List<DiskImage> diskImages() {
        return diskImages;
    }

    /**
     * <p>
     * The launch specification.
     * </p>
     * 
     * @return The launch specification.
     */
    public ImportInstanceLaunchSpecification launchSpecification() {
        return launchSpecification;
    }

    /**
     * <p>
     * The instance operating system.
     * </p>
     * 
     * @return The instance operating system.
     * @see PlatformValues
     */
    public String platform() {
        return platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((diskImages() == null) ? 0 : diskImages().hashCode());
        hashCode = 31 * hashCode + ((launchSpecification() == null) ? 0 : launchSpecification().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.diskImages() == null ^ this.diskImages() == null) {
            return false;
        }
        if (other.diskImages() != null && !other.diskImages().equals(this.diskImages())) {
            return false;
        }
        if (other.launchSpecification() == null ^ this.launchSpecification() == null) {
            return false;
        }
        if (other.launchSpecification() != null && !other.launchSpecification().equals(this.launchSpecification())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (diskImages() != null) {
            sb.append("DiskImages: ").append(diskImages()).append(",");
        }
        if (launchSpecification() != null) {
            sb.append("LaunchSpecification: ").append(launchSpecification()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ImportInstanceRequest> {
        /**
         * <p>
         * A description for the instance being imported.
         * </p>
         * 
         * @param description
         *        A description for the instance being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The disk image.
         * </p>
         * 
         * @param diskImages
         *        The disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskImages(Collection<DiskImage> diskImages);

        /**
         * <p>
         * The disk image.
         * </p>
         * 
         * @param diskImages
         *        The disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskImages(DiskImage... diskImages);

        /**
         * <p>
         * The launch specification.
         * </p>
         * 
         * @param launchSpecification
         *        The launch specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecification(ImportInstanceLaunchSpecification launchSpecification);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private List<DiskImage> diskImages;

        private ImportInstanceLaunchSpecification launchSpecification;

        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceRequest model) {
            setDescription(model.description);
            setDiskImages(model.diskImages);
            setLaunchSpecification(model.launchSpecification);
            setPlatform(model.platform);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DiskImage> getDiskImages() {
            return diskImages;
        }

        @Override
        public final Builder diskImages(Collection<DiskImage> diskImages) {
            this.diskImages = DiskImageListCopier.copy(diskImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(DiskImage... diskImages) {
            diskImages(Arrays.asList(diskImages));
            return this;
        }

        public final void setDiskImages(Collection<DiskImage> diskImages) {
            this.diskImages = DiskImageListCopier.copy(diskImages);
        }

        public final ImportInstanceLaunchSpecification getLaunchSpecification() {
            return launchSpecification;
        }

        @Override
        public final Builder launchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public ImportInstanceRequest build() {
            return new ImportInstanceRequest(this);
        }
    }
}
