/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ImportKeyPair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportKeyPairResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ImportKeyPairResponse.Builder, ImportKeyPairResponse> {
    private final String keyFingerprint;

    private final String keyName;

    private ImportKeyPairResponse(BuilderImpl builder) {
        this.keyFingerprint = builder.keyFingerprint;
        this.keyName = builder.keyName;
    }

    /**
     * <p>
     * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     * </p>
     * 
     * @return The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     */
    public String keyFingerprint() {
        return keyFingerprint;
    }

    /**
     * <p>
     * The key pair name you provided.
     * </p>
     * 
     * @return The key pair name you provided.
     */
    public String keyName() {
        return keyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyFingerprint() == null) ? 0 : keyFingerprint().hashCode());
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairResponse)) {
            return false;
        }
        ImportKeyPairResponse other = (ImportKeyPairResponse) obj;
        if (other.keyFingerprint() == null ^ this.keyFingerprint() == null) {
            return false;
        }
        if (other.keyFingerprint() != null && !other.keyFingerprint().equals(this.keyFingerprint())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyFingerprint() != null) {
            sb.append("KeyFingerprint: ").append(keyFingerprint()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ImportKeyPairResponse> {
        /**
         * <p>
         * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
         * </p>
         * 
         * @param keyFingerprint
         *        The MD5 public key fingerprint as specified in section 4 of RFC 4716.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFingerprint(String keyFingerprint);

        /**
         * <p>
         * The key pair name you provided.
         * </p>
         * 
         * @param keyName
         *        The key pair name you provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);
    }

    private static final class BuilderImpl implements Builder {
        private String keyFingerprint;

        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairResponse model) {
            setKeyFingerprint(model.keyFingerprint);
            setKeyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public ImportKeyPairResponse build() {
            return new ImportKeyPairResponse(this);
        }
    }
}
