/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Instance implements ToCopyableBuilder<Instance.Builder, Instance> {
    private final Integer amiLaunchIndex;

    private final String imageId;

    private final String instanceId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final Instant launchTime;

    private final Monitoring monitoring;

    private final Placement placement;

    private final String platform;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<ProductCode> productCodes;

    private final String publicDnsName;

    private final String publicIpAddress;

    private final String ramdiskId;

    private final InstanceState state;

    private final String stateTransitionReason;

    private final String subnetId;

    private final String vpcId;

    private final String architecture;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final String clientToken;

    private final Boolean ebsOptimized;

    private final Boolean enaSupport;

    private final String hypervisor;

    private final IamInstanceProfile iamInstanceProfile;

    private final String instanceLifecycle;

    private final List<InstanceNetworkInterface> networkInterfaces;

    private final String rootDeviceName;

    private final String rootDeviceType;

    private final List<GroupIdentifier> securityGroups;

    private final Boolean sourceDestCheck;

    private final String spotInstanceRequestId;

    private final String sriovNetSupport;

    private final StateReason stateReason;

    private final List<Tag> tags;

    private final String virtualizationType;

    private Instance(BuilderImpl builder) {
        this.amiLaunchIndex = builder.amiLaunchIndex;
        this.imageId = builder.imageId;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.launchTime = builder.launchTime;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.platform = builder.platform;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.productCodes = builder.productCodes;
        this.publicDnsName = builder.publicDnsName;
        this.publicIpAddress = builder.publicIpAddress;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.clientToken = builder.clientToken;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceLifecycle = builder.instanceLifecycle;
        this.networkInterfaces = builder.networkInterfaces;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
    }

    /**
     * <p>
     * The AMI launch index, which can be used to find this instance in the launch group.
     * </p>
     * 
     * @return The AMI launch index, which can be used to find this instance in the launch group.
     */
    public Integer amiLaunchIndex() {
        return amiLaunchIndex;
    }

    /**
     * <p>
     * The ID of the AMI used to launch the instance.
     * </p>
     * 
     * @return The ID of the AMI used to launch the instance.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The kernel associated with this instance, if applicable.
     * </p>
     * 
     * @return The kernel associated with this instance, if applicable.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair, if this instance was launched with an associated key pair.
     * </p>
     * 
     * @return The name of the key pair, if this instance was launched with an associated key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The time the instance was launched.
     * </p>
     * 
     * @return The time the instance was launched.
     */
    public Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public Monitoring monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The location where the instance launched, if applicable.
     * </p>
     * 
     * @return The location where the instance launched, if applicable.
     */
    public Placement placement() {
        return placement;
    }

    /**
     * <p>
     * The value is <code>Windows</code> for Windows instances; otherwise blank.
     * </p>
     * 
     * @return The value is <code>Windows</code> for Windows instances; otherwise blank.
     * @see PlatformValues
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the
     * Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state.
     * </p>
     * <p>
     * [EC2-VPC] The Amazon-provided DNS server will resolve Amazon-provided private DNS hostnames if you've enabled DNS
     * resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your
     * custom domain name servers must resolve the hostname as appropriate.
     * </p>
     * 
     * @return (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used
     *         inside the Amazon EC2 network. This name is not available until the instance enters the
     *         <code>running</code> state. </p>
     *         <p>
     *         [EC2-VPC] The Amazon-provided DNS server will resolve Amazon-provided private DNS hostnames if you've
     *         enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server
     *         in your VPC, your custom domain name servers must resolve the hostname as appropriate.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The private IPv4 address assigned to the instance.
     * </p>
     * 
     * @return The private IPv4 address assigned to the instance.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The product codes attached to this instance, if applicable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The product codes attached to this instance, if applicable.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters
     * the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your
     * VPC.
     * </p>
     * 
     * @return (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance
     *         enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS
     *         hostnames for your VPC.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The public IPv4 address assigned to the instance, if applicable.
     * </p>
     * 
     * @return The public IPv4 address assigned to the instance, if applicable.
     */
    public String publicIpAddress() {
        return publicIpAddress;
    }

    /**
     * <p>
     * The RAM disk associated with this instance, if applicable.
     * </p>
     * 
     * @return The RAM disk associated with this instance, if applicable.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * 
     * @return The current state of the instance.
     */
    public InstanceState state() {
        return state;
    }

    /**
     * <p>
     * The reason for the most recent state transition. This might be an empty string.
     * </p>
     * 
     * @return The reason for the most recent state transition. This might be an empty string.
     */
    public String stateTransitionReason() {
        return stateTransitionReason;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the subnet in which the instance is running.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the subnet in which the instance is running.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the VPC in which the instance is running.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the VPC in which the instance is running.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * Any block device mapping entries for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any block device mapping entries for the instance.
     */
    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The idempotency token you provided when you launched the instance, if applicable.
     * </p>
     * 
     * @return The idempotency token you provided when you launched the instance, if applicable.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput
     *         to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization
     *         isn't available with all instance types. Additional usage charges apply when using an EBS Optimized
     *         instance.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with ENA is enabled.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The hypervisor type of the instance.
     * </p>
     * 
     * @return The hypervisor type of the instance.
     * @see HypervisorType
     */
    public String hypervisor() {
        return hypervisor;
    }

    /**
     * <p>
     * The IAM instance profile associated with the instance, if applicable.
     * </p>
     * 
     * @return The IAM instance profile associated with the instance, if applicable.
     */
    public IamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Indicates whether this is a Spot instance or a Scheduled Instance.
     * </p>
     * 
     * @return Indicates whether this is a Spot instance or a Scheduled Instance.
     * @see InstanceLifecycleType
     */
    public String instanceLifecycle() {
        return instanceLifecycle;
    }

    /**
     * <p>
     * [EC2-VPC] One or more network interfaces for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-VPC] One or more network interfaces for the instance.
     */
    public List<InstanceNetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The root device name (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
     * </p>
     * 
     * @return The root device name (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
     */
    public String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * 
     * @return The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public String rootDeviceType() {
        return rootDeviceType;
    }

    /**
     * <p>
     * One or more security groups for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security groups for the instance.
     */
    public List<GroupIdentifier> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
     * source/destination checking is enabled on the instance. A value of <code>true</code> means checking is enabled,
     * and <code>false</code> means checking is disabled. The value must be <code>false</code> for the instance to
     * perform NAT. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
     *         source/destination checking is enabled on the instance. A value of <code>true</code> means checking is
     *         enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the
     *         instance to perform NAT. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in
     *         the <i>Amazon Virtual Private Cloud User Guide</i>.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * If the request is a Spot instance request, the ID of the request.
     * </p>
     * 
     * @return If the request is a Spot instance request, the ID of the request.
     */
    public String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The reason for the most recent state transition.
     * </p>
     * 
     * @return The reason for the most recent state transition.
     */
    public StateReason stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * Any tags assigned to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the instance.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The virtualization type of the instance.
     * </p>
     * 
     * @return The virtualization type of the instance.
     * @see VirtualizationType
     */
    public String virtualizationType() {
        return virtualizationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((amiLaunchIndex() == null) ? 0 : amiLaunchIndex().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        hashCode = 31 * hashCode + ((launchTime() == null) ? 0 : launchTime().hashCode());
        hashCode = 31 * hashCode + ((monitoring() == null) ? 0 : monitoring().hashCode());
        hashCode = 31 * hashCode + ((placement() == null) ? 0 : placement().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((privateDnsName() == null) ? 0 : privateDnsName().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        hashCode = 31 * hashCode + ((productCodes() == null) ? 0 : productCodes().hashCode());
        hashCode = 31 * hashCode + ((publicDnsName() == null) ? 0 : publicDnsName().hashCode());
        hashCode = 31 * hashCode + ((publicIpAddress() == null) ? 0 : publicIpAddress().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((stateTransitionReason() == null) ? 0 : stateTransitionReason().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        hashCode = 31 * hashCode + ((architecture() == null) ? 0 : architecture().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((enaSupport() == null) ? 0 : enaSupport().hashCode());
        hashCode = 31 * hashCode + ((hypervisor() == null) ? 0 : hypervisor().hashCode());
        hashCode = 31 * hashCode + ((iamInstanceProfile() == null) ? 0 : iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + ((instanceLifecycle() == null) ? 0 : instanceLifecycle().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaces() == null) ? 0 : networkInterfaces().hashCode());
        hashCode = 31 * hashCode + ((rootDeviceName() == null) ? 0 : rootDeviceName().hashCode());
        hashCode = 31 * hashCode + ((rootDeviceType() == null) ? 0 : rootDeviceType().hashCode());
        hashCode = 31 * hashCode + ((securityGroups() == null) ? 0 : securityGroups().hashCode());
        hashCode = 31 * hashCode + ((sourceDestCheck() == null) ? 0 : sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + ((spotInstanceRequestId() == null) ? 0 : spotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + ((sriovNetSupport() == null) ? 0 : sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + ((stateReason() == null) ? 0 : stateReason().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((virtualizationType() == null) ? 0 : virtualizationType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        if (other.amiLaunchIndex() == null ^ this.amiLaunchIndex() == null) {
            return false;
        }
        if (other.amiLaunchIndex() != null && !other.amiLaunchIndex().equals(this.amiLaunchIndex())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.launchTime() == null ^ this.launchTime() == null) {
            return false;
        }
        if (other.launchTime() != null && !other.launchTime().equals(this.launchTime())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.publicDnsName() == null ^ this.publicDnsName() == null) {
            return false;
        }
        if (other.publicDnsName() != null && !other.publicDnsName().equals(this.publicDnsName())) {
            return false;
        }
        if (other.publicIpAddress() == null ^ this.publicIpAddress() == null) {
            return false;
        }
        if (other.publicIpAddress() != null && !other.publicIpAddress().equals(this.publicIpAddress())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.stateTransitionReason() == null ^ this.stateTransitionReason() == null) {
            return false;
        }
        if (other.stateTransitionReason() != null && !other.stateTransitionReason().equals(this.stateTransitionReason())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.hypervisor() == null ^ this.hypervisor() == null) {
            return false;
        }
        if (other.hypervisor() != null && !other.hypervisor().equals(this.hypervisor())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.instanceLifecycle() == null ^ this.instanceLifecycle() == null) {
            return false;
        }
        if (other.instanceLifecycle() != null && !other.instanceLifecycle().equals(this.instanceLifecycle())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.rootDeviceName() == null ^ this.rootDeviceName() == null) {
            return false;
        }
        if (other.rootDeviceName() != null && !other.rootDeviceName().equals(this.rootDeviceName())) {
            return false;
        }
        if (other.rootDeviceType() == null ^ this.rootDeviceType() == null) {
            return false;
        }
        if (other.rootDeviceType() != null && !other.rootDeviceType().equals(this.rootDeviceType())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.spotInstanceRequestId() == null ^ this.spotInstanceRequestId() == null) {
            return false;
        }
        if (other.spotInstanceRequestId() != null && !other.spotInstanceRequestId().equals(this.spotInstanceRequestId())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.stateReason() == null ^ this.stateReason() == null) {
            return false;
        }
        if (other.stateReason() != null && !other.stateReason().equals(this.stateReason())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.virtualizationType() == null ^ this.virtualizationType() == null) {
            return false;
        }
        if (other.virtualizationType() != null && !other.virtualizationType().equals(this.virtualizationType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (amiLaunchIndex() != null) {
            sb.append("AmiLaunchIndex: ").append(amiLaunchIndex()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (launchTime() != null) {
            sb.append("LaunchTime: ").append(launchTime()).append(",");
        }
        if (monitoring() != null) {
            sb.append("Monitoring: ").append(monitoring()).append(",");
        }
        if (placement() != null) {
            sb.append("Placement: ").append(placement()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(privateDnsName()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (publicDnsName() != null) {
            sb.append("PublicDnsName: ").append(publicDnsName()).append(",");
        }
        if (publicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(publicIpAddress()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (stateTransitionReason() != null) {
            sb.append("StateTransitionReason: ").append(stateTransitionReason()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (architecture() != null) {
            sb.append("Architecture: ").append(architecture()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (enaSupport() != null) {
            sb.append("EnaSupport: ").append(enaSupport()).append(",");
        }
        if (hypervisor() != null) {
            sb.append("Hypervisor: ").append(hypervisor()).append(",");
        }
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (instanceLifecycle() != null) {
            sb.append("InstanceLifecycle: ").append(instanceLifecycle()).append(",");
        }
        if (networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(networkInterfaces()).append(",");
        }
        if (rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(rootDeviceName()).append(",");
        }
        if (rootDeviceType() != null) {
            sb.append("RootDeviceType: ").append(rootDeviceType()).append(",");
        }
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        if (sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(sourceDestCheck()).append(",");
        }
        if (spotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(spotInstanceRequestId()).append(",");
        }
        if (sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(sriovNetSupport()).append(",");
        }
        if (stateReason() != null) {
            sb.append("StateReason: ").append(stateReason()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (virtualizationType() != null) {
            sb.append("VirtualizationType: ").append(virtualizationType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The AMI launch index, which can be used to find this instance in the launch group.
         * </p>
         * 
         * @param amiLaunchIndex
         *        The AMI launch index, which can be used to find this instance in the launch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiLaunchIndex(Integer amiLaunchIndex);

        /**
         * <p>
         * The ID of the AMI used to launch the instance.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The kernel associated with this instance, if applicable.
         * </p>
         * 
         * @param kernelId
         *        The kernel associated with this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair, if this instance was launched with an associated key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair, if this instance was launched with an associated key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The time the instance was launched.
         * </p>
         * 
         * @param launchTime
         *        The time the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(Monitoring monitoring);

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * 
         * @param placement
         *        The location where the instance launched, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * The value is <code>Windows</code> for Windows instances; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows instances; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The value is <code>Windows</code> for Windows instances; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows instances; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside
         * the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state.
         * </p>
         * <p>
         * [EC2-VPC] The Amazon-provided DNS server will resolve Amazon-provided private DNS hostnames if you've enabled
         * DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your
         * VPC, your custom domain name servers must resolve the hostname as appropriate.
         * </p>
         * 
         * @param privateDnsName
         *        (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used
         *        inside the Amazon EC2 network. This name is not available until the instance enters the
         *        <code>running</code> state. </p>
         *        <p>
         *        [EC2-VPC] The Amazon-provided DNS server will resolve Amazon-provided private DNS hostnames if you've
         *        enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS
         *        server in your VPC, your custom domain name servers must resolve the hostname as appropriate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private IPv4 address assigned to the instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * 
         * @param productCodes
         *        The product codes attached to this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * 
         * @param productCodes
         *        The product codes attached to this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance
         * enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS
         * hostnames for your VPC.
         * </p>
         * 
         * @param publicDnsName
         *        (IPv4 only) The public DNS name assigned to the instance. This name is not available until the
         *        instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you've
         *        enabled DNS hostnames for your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The public IPv4 address assigned to the instance, if applicable.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IPv4 address assigned to the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);

        /**
         * <p>
         * The RAM disk associated with this instance, if applicable.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk associated with this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param state
         *        The current state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The reason for the most recent state transition. This might be an empty string.
         * </p>
         * 
         * @param stateTransitionReason
         *        The reason for the most recent state transition. This might be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);

        /**
         * <p>
         * [EC2-VPC] The ID of the subnet in which the instance is running.
         * </p>
         * 
         * @param subnetId
         *        [EC2-VPC] The ID of the subnet in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * [EC2-VPC] The ID of the VPC in which the instance is running.
         * </p>
         * 
         * @param vpcId
         *        [EC2-VPC] The ID of the VPC in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The idempotency token you provided when you launched the instance, if applicable.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token you provided when you launched the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't
         * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
         *        optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         *        Optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Specifies whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Specifies whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The hypervisor type of the instance.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the instance.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The hypervisor type of the instance.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the instance.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(HypervisorType hypervisor);

        /**
         * <p>
         * The IAM instance profile associated with the instance, if applicable.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile associated with the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile);

        /**
         * <p>
         * Indicates whether this is a Spot instance or a Scheduled Instance.
         * </p>
         * 
         * @param instanceLifecycle
         *        Indicates whether this is a Spot instance or a Scheduled Instance.
         * @see InstanceLifecycleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycleType
         */
        Builder instanceLifecycle(String instanceLifecycle);

        /**
         * <p>
         * Indicates whether this is a Spot instance or a Scheduled Instance.
         * </p>
         * 
         * @param instanceLifecycle
         *        Indicates whether this is a Spot instance or a Scheduled Instance.
         * @see InstanceLifecycleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycleType
         */
        Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle);

        /**
         * <p>
         * [EC2-VPC] One or more network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        [EC2-VPC] One or more network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces);

        /**
         * <p>
         * [EC2-VPC] One or more network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        [EC2-VPC] One or more network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterface... networkInterfaces);

        /**
         * <p>
         * The root device name (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The root device name (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(DeviceType rootDeviceType);

        /**
         * <p>
         * One or more security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<GroupIdentifier> securityGroups);

        /**
         * <p>
         * One or more security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(GroupIdentifier... securityGroups);

        /**
         * <p>
         * Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
         * source/destination checking is enabled on the instance. A value of <code>true</code> means checking is
         * enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the
         * instance to perform NAT. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the
         * <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param sourceDestCheck
         *        Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
         *        source/destination checking is enabled on the instance. A value of <code>true</code> means checking is
         *        enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for
         *        the instance to perform NAT. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a>
         *        in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * If the request is a Spot instance request, the ID of the request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        If the request is a Spot instance request, the ID of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The reason for the most recent state transition.
         * </p>
         * 
         * @param stateReason
         *        The reason for the most recent state transition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(StateReason stateReason);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The virtualization type of the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the instance.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The virtualization type of the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the instance.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);
    }

    private static final class BuilderImpl implements Builder {
        private Integer amiLaunchIndex;

        private String imageId;

        private String instanceId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private Instant launchTime;

        private Monitoring monitoring;

        private Placement placement;

        private String platform;

        private String privateDnsName;

        private String privateIpAddress;

        private List<ProductCode> productCodes;

        private String publicDnsName;

        private String publicIpAddress;

        private String ramdiskId;

        private InstanceState state;

        private String stateTransitionReason;

        private String subnetId;

        private String vpcId;

        private String architecture;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings;

        private String clientToken;

        private Boolean ebsOptimized;

        private Boolean enaSupport;

        private String hypervisor;

        private IamInstanceProfile iamInstanceProfile;

        private String instanceLifecycle;

        private List<InstanceNetworkInterface> networkInterfaces;

        private String rootDeviceName;

        private String rootDeviceType;

        private List<GroupIdentifier> securityGroups;

        private Boolean sourceDestCheck;

        private String spotInstanceRequestId;

        private String sriovNetSupport;

        private StateReason stateReason;

        private List<Tag> tags;

        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            setAmiLaunchIndex(model.amiLaunchIndex);
            setImageId(model.imageId);
            setInstanceId(model.instanceId);
            setInstanceType(model.instanceType);
            setKernelId(model.kernelId);
            setKeyName(model.keyName);
            setLaunchTime(model.launchTime);
            setMonitoring(model.monitoring);
            setPlacement(model.placement);
            setPlatform(model.platform);
            setPrivateDnsName(model.privateDnsName);
            setPrivateIpAddress(model.privateIpAddress);
            setProductCodes(model.productCodes);
            setPublicDnsName(model.publicDnsName);
            setPublicIpAddress(model.publicIpAddress);
            setRamdiskId(model.ramdiskId);
            setState(model.state);
            setStateTransitionReason(model.stateTransitionReason);
            setSubnetId(model.subnetId);
            setVpcId(model.vpcId);
            setArchitecture(model.architecture);
            setBlockDeviceMappings(model.blockDeviceMappings);
            setClientToken(model.clientToken);
            setEbsOptimized(model.ebsOptimized);
            setEnaSupport(model.enaSupport);
            setHypervisor(model.hypervisor);
            setIamInstanceProfile(model.iamInstanceProfile);
            setInstanceLifecycle(model.instanceLifecycle);
            setNetworkInterfaces(model.networkInterfaces);
            setRootDeviceName(model.rootDeviceName);
            setRootDeviceType(model.rootDeviceType);
            setSecurityGroups(model.securityGroups);
            setSourceDestCheck(model.sourceDestCheck);
            setSpotInstanceRequestId(model.spotInstanceRequestId);
            setSriovNetSupport(model.sriovNetSupport);
            setStateReason(model.stateReason);
            setTags(model.tags);
            setVirtualizationType(model.virtualizationType);
        }

        public final Integer getAmiLaunchIndex() {
            return amiLaunchIndex;
        }

        @Override
        public final Builder amiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public final void setAmiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        public final Monitoring getMonitoring() {
            return monitoring;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
        }

        public final Placement getPlacement() {
            return placement;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement placement) {
            this.placement = placement;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ProductCode> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final InstanceState getState() {
            return state;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState state) {
            this.state = state;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor.toString());
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final IamInstanceProfile getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getInstanceLifecycle() {
            return instanceLifecycle;
        }

        @Override
        public final Builder instanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
            return this;
        }

        @Override
        public final Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle) {
            this.instanceLifecycle(instanceLifecycle.toString());
            return this;
        }

        public final void setInstanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
        }

        public final Collection<InstanceNetworkInterface> getNetworkInterfaces() {
            return networkInterfaces;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copy(networkInterfaces);
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getRootDeviceType() {
            return rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final Collection<GroupIdentifier> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final StateReason getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(StateReason stateReason) {
            this.stateReason = stateReason;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }
    }
}
