/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceNetworkInterfaceAttachment implements
        ToCopyableBuilder<InstanceNetworkInterfaceAttachment.Builder, InstanceNetworkInterfaceAttachment> {
    private final Instant attachTime;

    private final String attachmentId;

    private final Boolean deleteOnTermination;

    private final Integer deviceIndex;

    private final String status;

    private InstanceNetworkInterfaceAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time stamp when the attachment initiated.
     * </p>
     * 
     * @return The time stamp when the attachment initiated.
     */
    public Instant attachTime() {
        return attachTime;
    }

    /**
     * <p>
     * The ID of the network interface attachment.
     * </p>
     * 
     * @return The ID of the network interface attachment.
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The index of the device on the instance for the network interface attachment.
     * </p>
     * 
     * @return The index of the device on the instance for the network interface attachment.
     */
    public Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * 
     * @return The attachment state.
     * @see AttachmentStatus
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attachTime() == null) ? 0 : attachTime().hashCode());
        hashCode = 31 * hashCode + ((attachmentId() == null) ? 0 : attachmentId().hashCode());
        hashCode = 31 * hashCode + ((deleteOnTermination() == null) ? 0 : deleteOnTermination().hashCode());
        hashCode = 31 * hashCode + ((deviceIndex() == null) ? 0 : deviceIndex().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceAttachment)) {
            return false;
        }
        InstanceNetworkInterfaceAttachment other = (InstanceNetworkInterfaceAttachment) obj;
        if (other.attachTime() == null ^ this.attachTime() == null) {
            return false;
        }
        if (other.attachTime() != null && !other.attachTime().equals(this.attachTime())) {
            return false;
        }
        if (other.attachmentId() == null ^ this.attachmentId() == null) {
            return false;
        }
        if (other.attachmentId() != null && !other.attachmentId().equals(this.attachmentId())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        if (other.deleteOnTermination() != null && !other.deleteOnTermination().equals(this.deleteOnTermination())) {
            return false;
        }
        if (other.deviceIndex() == null ^ this.deviceIndex() == null) {
            return false;
        }
        if (other.deviceIndex() != null && !other.deviceIndex().equals(this.deviceIndex())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attachTime() != null) {
            sb.append("AttachTime: ").append(attachTime()).append(",");
        }
        if (attachmentId() != null) {
            sb.append("AttachmentId: ").append(attachmentId()).append(",");
        }
        if (deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(deleteOnTermination()).append(",");
        }
        if (deviceIndex() != null) {
            sb.append("DeviceIndex: ").append(deviceIndex()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceNetworkInterfaceAttachment> {
        /**
         * <p>
         * The time stamp when the attachment initiated.
         * </p>
         * 
         * @param attachTime
         *        The time stamp when the attachment initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(Instant attachTime);

        /**
         * <p>
         * The ID of the network interface attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The index of the device on the instance for the network interface attachment.
         * </p>
         * 
         * @param deviceIndex
         *        The index of the device on the instance for the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The attachment state.
         * </p>
         * 
         * @param status
         *        The attachment state.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The attachment state.
         * </p>
         * 
         * @param status
         *        The attachment state.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(AttachmentStatus status);
    }

    private static final class BuilderImpl implements Builder {
        private Instant attachTime;

        private String attachmentId;

        private Boolean deleteOnTermination;

        private Integer deviceIndex;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceAttachment model) {
            setAttachTime(model.attachTime);
            setAttachmentId(model.attachmentId);
            setDeleteOnTermination(model.deleteOnTermination);
            setDeviceIndex(model.deviceIndex);
            setStatus(model.status);
        }

        public final Instant getAttachTime() {
            return attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public InstanceNetworkInterfaceAttachment build() {
            return new InstanceNetworkInterfaceAttachment(this);
        }
    }
}
