/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyHosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyHostsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyHostsRequest.Builder, ModifyHostsRequest> {
    private final String autoPlacement;

    private final List<String> hostIds;

    private ModifyHostsRequest(BuilderImpl builder) {
        this.autoPlacement = builder.autoPlacement;
        this.hostIds = builder.hostIds;
    }

    /**
     * <p>
     * Specify whether to enable or disable auto-placement.
     * </p>
     * 
     * @return Specify whether to enable or disable auto-placement.
     * @see AutoPlacement
     */
    public String autoPlacement() {
        return autoPlacement;
    }

    /**
     * <p>
     * The host IDs of the Dedicated Hosts you want to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The host IDs of the Dedicated Hosts you want to modify.
     */
    public List<String> hostIds() {
        return hostIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoPlacement() == null) ? 0 : autoPlacement().hashCode());
        hashCode = 31 * hashCode + ((hostIds() == null) ? 0 : hostIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsRequest)) {
            return false;
        }
        ModifyHostsRequest other = (ModifyHostsRequest) obj;
        if (other.autoPlacement() == null ^ this.autoPlacement() == null) {
            return false;
        }
        if (other.autoPlacement() != null && !other.autoPlacement().equals(this.autoPlacement())) {
            return false;
        }
        if (other.hostIds() == null ^ this.hostIds() == null) {
            return false;
        }
        if (other.hostIds() != null && !other.hostIds().equals(this.hostIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoPlacement() != null) {
            sb.append("AutoPlacement: ").append(autoPlacement()).append(",");
        }
        if (hostIds() != null) {
            sb.append("HostIds: ").append(hostIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyHostsRequest> {
        /**
         * <p>
         * Specify whether to enable or disable auto-placement.
         * </p>
         * 
         * @param autoPlacement
         *        Specify whether to enable or disable auto-placement.
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(String autoPlacement);

        /**
         * <p>
         * Specify whether to enable or disable auto-placement.
         * </p>
         * 
         * @param autoPlacement
         *        Specify whether to enable or disable auto-placement.
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(AutoPlacement autoPlacement);

        /**
         * <p>
         * The host IDs of the Dedicated Hosts you want to modify.
         * </p>
         * 
         * @param hostIds
         *        The host IDs of the Dedicated Hosts you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(Collection<String> hostIds);

        /**
         * <p>
         * The host IDs of the Dedicated Hosts you want to modify.
         * </p>
         * 
         * @param hostIds
         *        The host IDs of the Dedicated Hosts you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(String... hostIds);
    }

    private static final class BuilderImpl implements Builder {
        private String autoPlacement;

        private List<String> hostIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsRequest model) {
            setAutoPlacement(model.autoPlacement);
            setHostIds(model.hostIds);
        }

        public final String getAutoPlacement() {
            return autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final Collection<String> getHostIds() {
            return hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String... hostIds) {
            hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @Override
        public ModifyHostsRequest build() {
            return new ModifyHostsRequest(this);
        }
    }
}
