/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVolumeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ModifyVolumeResponse.Builder, ModifyVolumeResponse> {
    private final VolumeModification volumeModification;

    private ModifyVolumeResponse(BuilderImpl builder) {
        this.volumeModification = builder.volumeModification;
    }

    /**
     * <p>
     * A <a>VolumeModification</a> object.
     * </p>
     * 
     * @return A <a>VolumeModification</a> object.
     */
    public VolumeModification volumeModification() {
        return volumeModification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((volumeModification() == null) ? 0 : volumeModification().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeResponse)) {
            return false;
        }
        ModifyVolumeResponse other = (ModifyVolumeResponse) obj;
        if (other.volumeModification() == null ^ this.volumeModification() == null) {
            return false;
        }
        if (other.volumeModification() != null && !other.volumeModification().equals(this.volumeModification())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (volumeModification() != null) {
            sb.append("VolumeModification: ").append(volumeModification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyVolumeResponse> {
        /**
         * <p>
         * A <a>VolumeModification</a> object.
         * </p>
         * 
         * @param volumeModification
         *        A <a>VolumeModification</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeModification(VolumeModification volumeModification);
    }

    private static final class BuilderImpl implements Builder {
        private VolumeModification volumeModification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeResponse model) {
            setVolumeModification(model.volumeModification);
        }

        public final VolumeModification getVolumeModification() {
            return volumeModification;
        }

        @Override
        public final Builder volumeModification(VolumeModification volumeModification) {
            this.volumeModification = volumeModification;
            return this;
        }

        public final void setVolumeModification(VolumeModification volumeModification) {
            this.volumeModification = volumeModification;
        }

        @Override
        public ModifyVolumeResponse build() {
            return new ModifyVolumeResponse(this);
        }
    }
}
