/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for MoveAddressToVpc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MoveAddressToVpcRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<MoveAddressToVpcRequest.Builder, MoveAddressToVpcRequest> {
    private final String publicIp;

    private MoveAddressToVpcRequest(BuilderImpl builder) {
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveAddressToVpcRequest)) {
            return false;
        }
        MoveAddressToVpcRequest other = (MoveAddressToVpcRequest) obj;
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MoveAddressToVpcRequest> {
        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    private static final class BuilderImpl implements Builder {
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveAddressToVpcRequest model) {
            setPublicIp(model.publicIp);
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public MoveAddressToVpcRequest build() {
            return new MoveAddressToVpcRequest(this);
        }
    }
}
