/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of MoveAddressToVpc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MoveAddressToVpcResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<MoveAddressToVpcResponse.Builder, MoveAddressToVpcResponse> {
    private final String allocationId;

    private final String status;

    private MoveAddressToVpcResponse(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The allocation ID for the Elastic IP address.
     * </p>
     * 
     * @return The allocation ID for the Elastic IP address.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The status of the move of the IP address.
     * </p>
     * 
     * @return The status of the move of the IP address.
     * @see Status
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((allocationId() == null) ? 0 : allocationId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveAddressToVpcResponse)) {
            return false;
        }
        MoveAddressToVpcResponse other = (MoveAddressToVpcResponse) obj;
        if (other.allocationId() == null ^ this.allocationId() == null) {
            return false;
        }
        if (other.allocationId() != null && !other.allocationId().equals(this.allocationId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (allocationId() != null) {
            sb.append("AllocationId: ").append(allocationId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MoveAddressToVpcResponse> {
        /**
         * <p>
         * The allocation ID for the Elastic IP address.
         * </p>
         * 
         * @param allocationId
         *        The allocation ID for the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The status of the move of the IP address.
         * </p>
         * 
         * @param status
         *        The status of the move of the IP address.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the move of the IP address.
         * </p>
         * 
         * @param status
         *        The status of the move of the IP address.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    private static final class BuilderImpl implements Builder {
        private String allocationId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveAddressToVpcResponse model) {
            setAllocationId(model.allocationId);
            setStatus(model.status);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public MoveAddressToVpcResponse build() {
            return new MoveAddressToVpcResponse(this);
        }
    }
}
