/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the private IPv4 address of a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkInterfacePrivateIpAddress implements
        ToCopyableBuilder<NetworkInterfacePrivateIpAddress.Builder, NetworkInterfacePrivateIpAddress> {
    private final NetworkInterfaceAssociation association;

    private final Boolean primary;

    private final String privateDnsName;

    private final String privateIpAddress;

    private NetworkInterfacePrivateIpAddress(BuilderImpl builder) {
        this.association = builder.association;
        this.primary = builder.primary;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     * </p>
     * 
     * @return The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    public NetworkInterfaceAssociation association() {
        return association;
    }

    /**
     * <p>
     * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
     * </p>
     * 
     * @return Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
     */
    public Boolean primary() {
        return primary;
    }

    /**
     * <p>
     * The private DNS name.
     * </p>
     * 
     * @return The private DNS name.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The private IPv4 address.
     * </p>
     * 
     * @return The private IPv4 address.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((association() == null) ? 0 : association().hashCode());
        hashCode = 31 * hashCode + ((primary() == null) ? 0 : primary().hashCode());
        hashCode = 31 * hashCode + ((privateDnsName() == null) ? 0 : privateDnsName().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePrivateIpAddress)) {
            return false;
        }
        NetworkInterfacePrivateIpAddress other = (NetworkInterfacePrivateIpAddress) obj;
        if (other.association() == null ^ this.association() == null) {
            return false;
        }
        if (other.association() != null && !other.association().equals(this.association())) {
            return false;
        }
        if (other.primary() == null ^ this.primary() == null) {
            return false;
        }
        if (other.primary() != null && !other.primary().equals(this.primary())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (association() != null) {
            sb.append("Association: ").append(association()).append(",");
        }
        if (primary() != null) {
            sb.append("Primary: ").append(primary()).append(",");
        }
        if (privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(privateDnsName()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * 
         * @param association
         *        The association information for an Elastic IP address (IPv4) associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(NetworkInterfaceAssociation association);

        /**
         * <p>
         * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         * </p>
         * 
         * @param primary
         *        Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);

        /**
         * <p>
         * The private DNS name.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private IPv4 address.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);
    }

    private static final class BuilderImpl implements Builder {
        private NetworkInterfaceAssociation association;

        private Boolean primary;

        private String privateDnsName;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePrivateIpAddress model) {
            setAssociation(model.association);
            setPrimary(model.primary);
            setPrivateDnsName(model.privateDnsName);
            setPrivateIpAddress(model.privateIpAddress);
        }

        public final NetworkInterfaceAssociation getAssociation() {
            return association;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation association) {
            this.association = association;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public NetworkInterfacePrivateIpAddress build() {
            return new NetworkInterfacePrivateIpAddress(this);
        }
    }
}
