/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data that identifies an Amazon FPGA image (AFI) on the PCI bus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PciId implements ToCopyableBuilder<PciId.Builder, PciId> {
    private final String deviceId;

    private final String vendorId;

    private final String subsystemId;

    private final String subsystemVendorId;

    private PciId(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.vendorId = builder.vendorId;
        this.subsystemId = builder.subsystemId;
        this.subsystemVendorId = builder.subsystemVendorId;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The ID of the vendor.
     * </p>
     * 
     * @return The ID of the vendor.
     */
    public String vendorId() {
        return vendorId;
    }

    /**
     * <p>
     * The ID of the subsystem.
     * </p>
     * 
     * @return The ID of the subsystem.
     */
    public String subsystemId() {
        return subsystemId;
    }

    /**
     * <p>
     * The ID of the vendor for the subsystem.
     * </p>
     * 
     * @return The ID of the vendor for the subsystem.
     */
    public String subsystemVendorId() {
        return subsystemVendorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deviceId() == null) ? 0 : deviceId().hashCode());
        hashCode = 31 * hashCode + ((vendorId() == null) ? 0 : vendorId().hashCode());
        hashCode = 31 * hashCode + ((subsystemId() == null) ? 0 : subsystemId().hashCode());
        hashCode = 31 * hashCode + ((subsystemVendorId() == null) ? 0 : subsystemVendorId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PciId)) {
            return false;
        }
        PciId other = (PciId) obj;
        if (other.deviceId() == null ^ this.deviceId() == null) {
            return false;
        }
        if (other.deviceId() != null && !other.deviceId().equals(this.deviceId())) {
            return false;
        }
        if (other.vendorId() == null ^ this.vendorId() == null) {
            return false;
        }
        if (other.vendorId() != null && !other.vendorId().equals(this.vendorId())) {
            return false;
        }
        if (other.subsystemId() == null ^ this.subsystemId() == null) {
            return false;
        }
        if (other.subsystemId() != null && !other.subsystemId().equals(this.subsystemId())) {
            return false;
        }
        if (other.subsystemVendorId() == null ^ this.subsystemVendorId() == null) {
            return false;
        }
        if (other.subsystemVendorId() != null && !other.subsystemVendorId().equals(this.subsystemVendorId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deviceId() != null) {
            sb.append("DeviceId: ").append(deviceId()).append(",");
        }
        if (vendorId() != null) {
            sb.append("VendorId: ").append(vendorId()).append(",");
        }
        if (subsystemId() != null) {
            sb.append("SubsystemId: ").append(subsystemId()).append(",");
        }
        if (subsystemVendorId() != null) {
            sb.append("SubsystemVendorId: ").append(subsystemVendorId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PciId> {
        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The ID of the vendor.
         * </p>
         * 
         * @param vendorId
         *        The ID of the vendor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorId(String vendorId);

        /**
         * <p>
         * The ID of the subsystem.
         * </p>
         * 
         * @param subsystemId
         *        The ID of the subsystem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subsystemId(String subsystemId);

        /**
         * <p>
         * The ID of the vendor for the subsystem.
         * </p>
         * 
         * @param subsystemVendorId
         *        The ID of the vendor for the subsystem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subsystemVendorId(String subsystemVendorId);
    }

    private static final class BuilderImpl implements Builder {
        private String deviceId;

        private String vendorId;

        private String subsystemId;

        private String subsystemVendorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PciId model) {
            setDeviceId(model.deviceId);
            setVendorId(model.vendorId);
            setSubsystemId(model.subsystemId);
            setSubsystemVendorId(model.subsystemVendorId);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getVendorId() {
            return vendorId;
        }

        @Override
        public final Builder vendorId(String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public final void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public final String getSubsystemId() {
            return subsystemId;
        }

        @Override
        public final Builder subsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
            return this;
        }

        public final void setSubsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
        }

        public final String getSubsystemVendorId() {
            return subsystemVendorId;
        }

        @Override
        public final Builder subsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
            return this;
        }

        public final void setSubsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
        }

        @Override
        public PciId build() {
            return new PciId(this);
        }
    }
}
