/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recurring charge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecurringCharge implements ToCopyableBuilder<RecurringCharge.Builder, RecurringCharge> {
    private final Double amount;

    private final String frequency;

    private RecurringCharge(BuilderImpl builder) {
        this.amount = builder.amount;
        this.frequency = builder.frequency;
    }

    /**
     * <p>
     * The amount of the recurring charge.
     * </p>
     * 
     * @return The amount of the recurring charge.
     */
    public Double amount() {
        return amount;
    }

    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     * 
     * @return The frequency of the recurring charge.
     * @see RecurringChargeFrequency
     */
    public String frequency() {
        return frequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((amount() == null) ? 0 : amount().hashCode());
        hashCode = 31 * hashCode + ((frequency() == null) ? 0 : frequency().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge) obj;
        if (other.amount() == null ^ this.amount() == null) {
            return false;
        }
        if (other.amount() != null && !other.amount().equals(this.amount())) {
            return false;
        }
        if (other.frequency() == null ^ this.frequency() == null) {
            return false;
        }
        if (other.frequency() != null && !other.frequency().equals(this.frequency())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (amount() != null) {
            sb.append("Amount: ").append(amount()).append(",");
        }
        if (frequency() != null) {
            sb.append("Frequency: ").append(frequency()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RecurringCharge> {
        /**
         * <p>
         * The amount of the recurring charge.
         * </p>
         * 
         * @param amount
         *        The amount of the recurring charge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * The frequency of the recurring charge.
         * </p>
         * 
         * @param frequency
         *        The frequency of the recurring charge.
         * @see RecurringChargeFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecurringChargeFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The frequency of the recurring charge.
         * </p>
         * 
         * @param frequency
         *        The frequency of the recurring charge.
         * @see RecurringChargeFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecurringChargeFrequency
         */
        Builder frequency(RecurringChargeFrequency frequency);
    }

    private static final class BuilderImpl implements Builder {
        private Double amount;

        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            setAmount(model.amount);
            setFrequency(model.frequency);
        }

        public final Double getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(RecurringChargeFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public RecurringCharge build() {
            return new RecurringCharge(this);
        }
    }
}
