/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ReportInstanceStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReportInstanceStatusRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ReportInstanceStatusRequest.Builder, ReportInstanceStatusRequest> {
    private final String description;

    private final Instant endTime;

    private final List<String> instances;

    private final List<String> reasonCodes;

    private final Instant startTime;

    private final String status;

    private ReportInstanceStatusRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.endTime = builder.endTime;
        this.instances = builder.instances;
        this.reasonCodes = builder.reasonCodes;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * Descriptive text about the health state of your instance.
     * </p>
     * 
     * @return Descriptive text about the health state of your instance.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The time at which the reported instance health state ended.
     * </p>
     * 
     * @return The time at which the reported instance health state ended.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * One or more instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instances.
     */
    public List<String> instances() {
        return instances;
    }

    /**
     * <p>
     * One or more reason codes that describes the health state of your instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unresponsive</code>: My instance is unresponsive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>password-not-available</code>: A password is not available for my instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-network</code>: My instance is experiencing performance problems which I believe are network
     * related.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-instance-store</code>: My instance is experiencing performance problems which I believe are
     * related to the instance stores.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe are related
     * to an EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-other</code>: My instance is experiencing performance problems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>other</code>: [explain using the description parameter]
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more reason codes that describes the health state of your instance.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unresponsive</code>: My instance is unresponsive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>password-not-available</code>: A password is not available for my instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-network</code>: My instance is experiencing performance problems which I believe are
     *         network related.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-instance-store</code>: My instance is experiencing performance problems which I believe
     *         are related to the instance stores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe are
     *         related to an EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-other</code>: My instance is experiencing performance problems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>other</code>: [explain using the description parameter]
     *         </p>
     *         </li>
     * @see ReportInstanceReasonCodes
     */
    public List<String> reasonCodes() {
        return reasonCodes;
    }

    /**
     * <p>
     * The time at which the reported instance health state began.
     * </p>
     * 
     * @return The time at which the reported instance health state began.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of all instances listed.
     * </p>
     * 
     * @return The status of all instances listed.
     * @see ReportStatusType
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((instances() == null) ? 0 : instances().hashCode());
        hashCode = 31 * hashCode + ((reasonCodes() == null) ? 0 : reasonCodes().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.reasonCodes() == null ^ this.reasonCodes() == null) {
            return false;
        }
        if (other.reasonCodes() != null && !other.reasonCodes().equals(this.reasonCodes())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (instances() != null) {
            sb.append("Instances: ").append(instances()).append(",");
        }
        if (reasonCodes() != null) {
            sb.append("ReasonCodes: ").append(reasonCodes()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReportInstanceStatusRequest> {
        /**
         * <p>
         * Descriptive text about the health state of your instance.
         * </p>
         * 
         * @param description
         *        Descriptive text about the health state of your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time at which the reported instance health state ended.
         * </p>
         * 
         * @param endTime
         *        The time at which the reported instance health state ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<String> instances);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(String... instances);

        /**
         * <p>
         * One or more reason codes that describes the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems which I believe are
         * network related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems which I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        One or more reason codes that describes the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems which I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems which I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @see ReportInstanceReasonCodes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportInstanceReasonCodes
         */
        Builder reasonCodes(Collection<String> reasonCodes);

        /**
         * <p>
         * One or more reason codes that describes the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems which I believe are
         * network related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems which I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        One or more reason codes that describes the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems which I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems which I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @see ReportInstanceReasonCodes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportInstanceReasonCodes
         */
        Builder reasonCodes(String... reasonCodes);

        /**
         * <p>
         * One or more reason codes that describes the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems which I believe are
         * network related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems which I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        One or more reason codes that describes the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems which I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems which I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @see ReportInstanceReasonCodes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportInstanceReasonCodes
         */
        Builder reasonCodes(ReportInstanceReasonCodes... reasonCodes);

        /**
         * <p>
         * The time at which the reported instance health state began.
         * </p>
         * 
         * @param startTime
         *        The time at which the reported instance health state began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of all instances listed.
         * </p>
         * 
         * @param status
         *        The status of all instances listed.
         * @see ReportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of all instances listed.
         * </p>
         * 
         * @param status
         *        The status of all instances listed.
         * @see ReportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStatusType
         */
        Builder status(ReportStatusType status);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private Instant endTime;

        private List<String> instances;

        private List<String> reasonCodes;

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportInstanceStatusRequest model) {
            setDescription(model.description);
            setEndTime(model.endTime);
            setInstances(model.instances);
            setReasonCodes(model.reasonCodes);
            setStartTime(model.startTime);
            setStatus(model.status);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<String> getInstances() {
            return instances;
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
        }

        public final Collection<String> getReasonCodes() {
            return reasonCodes;
        }

        @Override
        public final Builder reasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(String... reasonCodes) {
            reasonCodes(Arrays.asList(reasonCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(ReportInstanceReasonCodes... reasonCodes) {
            reasonCodes(Arrays.asList(reasonCodes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setReasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ReportInstanceStatusRequest build() {
            return new ReportInstanceStatusRequest(this);
        }
    }
}
