/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstances implements ToCopyableBuilder<ReservedInstances.Builder, ReservedInstances> {
    private final String availabilityZone;

    private final Long duration;

    private final Instant end;

    private final Float fixedPrice;

    private final Integer instanceCount;

    private final String instanceType;

    private final String productDescription;

    private final String reservedInstancesId;

    private final Instant start;

    private final String state;

    private final Float usagePrice;

    private final String currencyCode;

    private final String instanceTenancy;

    private final String offeringClass;

    private final String offeringType;

    private final List<RecurringCharge> recurringCharges;

    private final String scope;

    private final List<Tag> tags;

    private ReservedInstances(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.end = builder.end;
        this.fixedPrice = builder.fixedPrice;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.start = builder.start;
        this.state = builder.state;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The duration of the Reserved Instance, in seconds.
     * </p>
     * 
     * @return The duration of the Reserved Instance, in seconds.
     */
    public Long duration() {
        return duration;
    }

    /**
     * <p>
     * The time when the Reserved Instance expires.
     * </p>
     * 
     * @return The time when the Reserved Instance expires.
     */
    public Instant end() {
        return end;
    }

    /**
     * <p>
     * The purchase price of the Reserved Instance.
     * </p>
     * 
     * @return The purchase price of the Reserved Instance.
     */
    public Float fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The number of reservations purchased.
     * </p>
     * 
     * @return The number of reservations purchased.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The ID of the Reserved Instance.
     * </p>
     * 
     * @return The ID of the Reserved Instance.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The date and time the Reserved Instance started.
     * </p>
     * 
     * @return The date and time the Reserved Instance started.
     */
    public Instant start() {
        return start;
    }

    /**
     * <p>
     * The state of the Reserved Instance purchase.
     * </p>
     * 
     * @return The state of the Reserved Instance purchase.
     * @see ReservedInstanceState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The usage price of the Reserved Instance, per hour.
     * </p>
     * 
     * @return The usage price of the Reserved Instance, per hour.
     */
    public Float usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time, the
     * only supported currency is <code>USD</code>.
     * </p>
     * 
     * @return The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
     *         time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public String instanceTenancy() {
        return instanceTenancy;
    }

    /**
     * <p>
     * The offering class of the Reserved Instance.
     * </p>
     * 
     * @return The offering class of the Reserved Instance.
     * @see OfferingClassType
     */
    public String offeringClass() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public String offeringType() {
        return offeringType;
    }

    /**
     * <p>
     * The recurring charge tag assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The recurring charge tag assigned to the resource.
     */
    public List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * The scope of the Reserved Instance.
     * </p>
     * 
     * @return The scope of the Reserved Instance.
     * @see Scope
     */
    public String scope() {
        return scope;
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((duration() == null) ? 0 : duration().hashCode());
        hashCode = 31 * hashCode + ((end() == null) ? 0 : end().hashCode());
        hashCode = 31 * hashCode + ((fixedPrice() == null) ? 0 : fixedPrice().hashCode());
        hashCode = 31 * hashCode + ((instanceCount() == null) ? 0 : instanceCount().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((productDescription() == null) ? 0 : productDescription().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesId() == null) ? 0 : reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + ((start() == null) ? 0 : start().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((usagePrice() == null) ? 0 : usagePrice().hashCode());
        hashCode = 31 * hashCode + ((currencyCode() == null) ? 0 : currencyCode().hashCode());
        hashCode = 31 * hashCode + ((instanceTenancy() == null) ? 0 : instanceTenancy().hashCode());
        hashCode = 31 * hashCode + ((offeringClass() == null) ? 0 : offeringClass().hashCode());
        hashCode = 31 * hashCode + ((offeringType() == null) ? 0 : offeringType().hashCode());
        hashCode = 31 * hashCode + ((recurringCharges() == null) ? 0 : recurringCharges().hashCode());
        hashCode = 31 * hashCode + ((scope() == null) ? 0 : scope().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstances)) {
            return false;
        }
        ReservedInstances other = (ReservedInstances) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        if (other.offeringClass() == null ^ this.offeringClass() == null) {
            return false;
        }
        if (other.offeringClass() != null && !other.offeringClass().equals(this.offeringClass())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        if (other.offeringType() != null && !other.offeringType().equals(this.offeringType())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        if (other.recurringCharges() != null && !other.recurringCharges().equals(this.recurringCharges())) {
            return false;
        }
        if (other.scope() == null ^ this.scope() == null) {
            return false;
        }
        if (other.scope() != null && !other.scope().equals(this.scope())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (end() != null) {
            sb.append("End: ").append(end()).append(",");
        }
        if (fixedPrice() != null) {
            sb.append("FixedPrice: ").append(fixedPrice()).append(",");
        }
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (productDescription() != null) {
            sb.append("ProductDescription: ").append(productDescription()).append(",");
        }
        if (reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(reservedInstancesId()).append(",");
        }
        if (start() != null) {
            sb.append("Start: ").append(start()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (usagePrice() != null) {
            sb.append("UsagePrice: ").append(usagePrice()).append(",");
        }
        if (currencyCode() != null) {
            sb.append("CurrencyCode: ").append(currencyCode()).append(",");
        }
        if (instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(instanceTenancy()).append(",");
        }
        if (offeringClass() != null) {
            sb.append("OfferingClass: ").append(offeringClass()).append(",");
        }
        if (offeringType() != null) {
            sb.append("OfferingType: ").append(offeringType()).append(",");
        }
        if (recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(recurringCharges()).append(",");
        }
        if (scope() != null) {
            sb.append("Scope: ").append(scope()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstances> {
        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The duration of the Reserved Instance, in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the Reserved Instance, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The time when the Reserved Instance expires.
         * </p>
         * 
         * @param end
         *        The time when the Reserved Instance expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * The purchase price of the Reserved Instance.
         * </p>
         * 
         * @param fixedPrice
         *        The purchase price of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Float fixedPrice);

        /**
         * <p>
         * The number of reservations purchased.
         * </p>
         * 
         * @param instanceCount
         *        The number of reservations purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * The ID of the Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The date and time the Reserved Instance started.
         * </p>
         * 
         * @param start
         *        The date and time the Reserved Instance started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The state of the Reserved Instance purchase.
         * </p>
         * 
         * @param state
         *        The state of the Reserved Instance purchase.
         * @see ReservedInstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedInstanceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Reserved Instance purchase.
         * </p>
         * 
         * @param state
         *        The state of the Reserved Instance purchase.
         * @see ReservedInstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedInstanceState
         */
        Builder state(ReservedInstanceState state);

        /**
         * <p>
         * The usage price of the Reserved Instance, per hour.
         * </p>
         * 
         * @param usagePrice
         *        The usage price of the Reserved Instance, per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Float usagePrice);

        /**
         * <p>
         * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time,
         * the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
         *        time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time,
         * the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
         *        time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * The offering class of the Reserved Instance.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * The offering class of the Reserved Instance.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The scope of the Reserved Instance.
         * </p>
         * 
         * @param scope
         *        The scope of the Reserved Instance.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of the Reserved Instance.
         * </p>
         * 
         * @param scope
         *        The scope of the Reserved Instance.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Long duration;

        private Instant end;

        private Float fixedPrice;

        private Integer instanceCount;

        private String instanceType;

        private String productDescription;

        private String reservedInstancesId;

        private Instant start;

        private String state;

        private Float usagePrice;

        private String currencyCode;

        private String instanceTenancy;

        private String offeringClass;

        private String offeringType;

        private List<RecurringCharge> recurringCharges;

        private String scope;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstances model) {
            setAvailabilityZone(model.availabilityZone);
            setDuration(model.duration);
            setEnd(model.end);
            setFixedPrice(model.fixedPrice);
            setInstanceCount(model.instanceCount);
            setInstanceType(model.instanceType);
            setProductDescription(model.productDescription);
            setReservedInstancesId(model.reservedInstancesId);
            setStart(model.start);
            setState(model.state);
            setUsagePrice(model.usagePrice);
            setCurrencyCode(model.currencyCode);
            setInstanceTenancy(model.instanceTenancy);
            setOfferingClass(model.offeringClass);
            setOfferingType(model.offeringType);
            setRecurringCharges(model.recurringCharges);
            setScope(model.scope);
            setTags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Instant getEnd() {
            return end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final Float getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservedInstanceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Float getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<RecurringCharge> getRecurringCharges() {
            return recurringCharges;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        public ReservedInstances build() {
            return new ReservedInstances(this);
        }
    }
}
