/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ResetInstanceAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResetInstanceAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ResetInstanceAttributeRequest.Builder, ResetInstanceAttributeRequest> {
    private final String attribute;

    private final String instanceId;

    private ResetInstanceAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The attribute to reset.
     * </p>
     * <important>
     * <p>
     * You can only reset the following attributes: <code>kernel</code> | <code>ramdisk</code> |
     * <code>sourceDestCheck</code>. To change an instance attribute, use <a>ModifyInstanceAttribute</a>.
     * </p>
     * </important>
     * 
     * @return The attribute to reset.</p> <important>
     *         <p>
     *         You can only reset the following attributes: <code>kernel</code> | <code>ramdisk</code> |
     *         <code>sourceDestCheck</code>. To change an instance attribute, use <a>ModifyInstanceAttribute</a>.
     *         </p>
     * @see InstanceAttributeName
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetInstanceAttributeRequest)) {
            return false;
        }
        ResetInstanceAttributeRequest other = (ResetInstanceAttributeRequest) obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ResetInstanceAttributeRequest> {
        /**
         * <p>
         * The attribute to reset.
         * </p>
         * <important>
         * <p>
         * You can only reset the following attributes: <code>kernel</code> | <code>ramdisk</code> |
         * <code>sourceDestCheck</code>. To change an instance attribute, use <a>ModifyInstanceAttribute</a>.
         * </p>
         * </important>
         * 
         * @param attribute
         *        The attribute to reset.</p> <important>
         *        <p>
         *        You can only reset the following attributes: <code>kernel</code> | <code>ramdisk</code> |
         *        <code>sourceDestCheck</code>. To change an instance attribute, use <a>ModifyInstanceAttribute</a>.
         *        </p>
         * @see InstanceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute to reset.
         * </p>
         * <important>
         * <p>
         * You can only reset the following attributes: <code>kernel</code> | <code>ramdisk</code> |
         * <code>sourceDestCheck</code>. To change an instance attribute, use <a>ModifyInstanceAttribute</a>.
         * </p>
         * </important>
         * 
         * @param attribute
         *        The attribute to reset.</p> <important>
         *        <p>
         *        You can only reset the following attributes: <code>kernel</code> | <code>ramdisk</code> |
         *        <code>sourceDestCheck</code>. To change an instance attribute, use <a>ModifyInstanceAttribute</a>.
         *        </p>
         * @see InstanceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeName
         */
        Builder attribute(InstanceAttributeName attribute);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    private static final class BuilderImpl implements Builder {
        private String attribute;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetInstanceAttributeRequest model) {
            setAttribute(model.attribute);
            setInstanceId(model.instanceId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public ResetInstanceAttributeRequest build() {
            return new ResetInstanceAttributeRequest(this);
        }
    }
}
