/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ResetSnapshotAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResetSnapshotAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ResetSnapshotAttributeRequest.Builder, ResetSnapshotAttributeRequest> {
    private final String attribute;

    private final String snapshotId;

    private ResetSnapshotAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * </p>
     * 
     * @return The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * @see SnapshotAttributeName
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((snapshotId() == null) ? 0 : snapshotId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetSnapshotAttributeRequest)) {
            return false;
        }
        ResetSnapshotAttributeRequest other = (ResetSnapshotAttributeRequest) obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ResetSnapshotAttributeRequest> {
        /**
         * <p>
         * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * </p>
         * 
         * @param attribute
         *        The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * </p>
         * 
         * @param attribute
         *        The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(SnapshotAttributeName attribute);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);
    }

    private static final class BuilderImpl implements Builder {
        private String attribute;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetSnapshotAttributeRequest model) {
            setAttribute(model.attribute);
            setSnapshotId(model.snapshotId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SnapshotAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public ResetSnapshotAttributeRequest build() {
            return new ResetSnapshotAttributeRequest(this);
        }
    }
}
