/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the storage parameters for S3 and S3 buckets for an instance store-backed AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Storage implements ToCopyableBuilder<S3Storage.Builder, S3Storage> {
    private final String awsAccessKeyId;

    private final String bucket;

    private final String prefix;

    private final String uploadPolicy;

    private final String uploadPolicySignature;

    private S3Storage(BuilderImpl builder) {
        this.awsAccessKeyId = builder.awsAccessKeyId;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.uploadPolicy = builder.uploadPolicy;
        this.uploadPolicySignature = builder.uploadPolicySignature;
    }

    /**
     * <p>
     * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and
     * follow the guidance in <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices for
     * Managing AWS Access Keys</a>.
     * </p>
     * 
     * @return The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review
     *         and follow the guidance in <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices
     *         for Managing AWS Access Keys</a>.
     */
    public String awsAccessKeyId() {
        return awsAccessKeyId;
    }

    /**
     * <p>
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon
     * EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     * </p>
     * 
     * @return The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
     *         Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2
     *         returns an error.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The beginning of the file name of the AMI.
     * </p>
     * 
     * @return The beginning of the file name of the AMI.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
     * </p>
     * 
     * @return An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your
     *         behalf.
     */
    public String uploadPolicy() {
        return uploadPolicy;
    }

    /**
     * <p>
     * The signature of the JSON document.
     * </p>
     * 
     * @return The signature of the JSON document.
     */
    public String uploadPolicySignature() {
        return uploadPolicySignature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((awsAccessKeyId() == null) ? 0 : awsAccessKeyId().hashCode());
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((uploadPolicy() == null) ? 0 : uploadPolicy().hashCode());
        hashCode = 31 * hashCode + ((uploadPolicySignature() == null) ? 0 : uploadPolicySignature().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Storage)) {
            return false;
        }
        S3Storage other = (S3Storage) obj;
        if (other.awsAccessKeyId() == null ^ this.awsAccessKeyId() == null) {
            return false;
        }
        if (other.awsAccessKeyId() != null && !other.awsAccessKeyId().equals(this.awsAccessKeyId())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.uploadPolicy() == null ^ this.uploadPolicy() == null) {
            return false;
        }
        if (other.uploadPolicy() != null && !other.uploadPolicy().equals(this.uploadPolicy())) {
            return false;
        }
        if (other.uploadPolicySignature() == null ^ this.uploadPolicySignature() == null) {
            return false;
        }
        if (other.uploadPolicySignature() != null && !other.uploadPolicySignature().equals(this.uploadPolicySignature())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (awsAccessKeyId() != null) {
            sb.append("AWSAccessKeyId: ").append(awsAccessKeyId()).append(",");
        }
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (uploadPolicy() != null) {
            sb.append("UploadPolicy: ").append(uploadPolicy()).append(",");
        }
        if (uploadPolicySignature() != null) {
            sb.append("UploadPolicySignature: ").append(uploadPolicySignature()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, S3Storage> {
        /**
         * <p>
         * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and
         * follow the guidance in <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices for
         * Managing AWS Access Keys</a>.
         * </p>
         * 
         * @param awsAccessKeyId
         *        The access key ID of the owner of the bucket. Before you specify a value for your access key ID,
         *        review and follow the guidance in <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices
         *        for Managing AWS Access Keys</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccessKeyId(String awsAccessKeyId);

        /**
         * <p>
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
         * Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns
         * an error.
         * </p>
         * 
         * @param bucket
         *        The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket
         *        that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon
         *        EC2 returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The beginning of the file name of the AMI.
         * </p>
         * 
         * @param prefix
         *        The beginning of the file name of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
         * </p>
         * 
         * @param uploadPolicy
         *        An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your
         *        behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadPolicy(String uploadPolicy);

        /**
         * <p>
         * The signature of the JSON document.
         * </p>
         * 
         * @param uploadPolicySignature
         *        The signature of the JSON document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadPolicySignature(String uploadPolicySignature);
    }

    private static final class BuilderImpl implements Builder {
        private String awsAccessKeyId;

        private String bucket;

        private String prefix;

        private String uploadPolicy;

        private String uploadPolicySignature;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Storage model) {
            setAWSAccessKeyId(model.awsAccessKeyId);
            setBucket(model.bucket);
            setPrefix(model.prefix);
            setUploadPolicy(model.uploadPolicy);
            setUploadPolicySignature(model.uploadPolicySignature);
        }

        public final String getAWSAccessKeyId() {
            return awsAccessKeyId;
        }

        @Override
        public final Builder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        public final void setAWSAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getUploadPolicy() {
            return uploadPolicy;
        }

        @Override
        public final Builder uploadPolicy(String uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
            return this;
        }

        public final void setUploadPolicy(String uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
        }

        public final String getUploadPolicySignature() {
            return uploadPolicySignature;
        }

        @Override
        public final Builder uploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
            return this;
        }

        public final void setUploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
        }

        @Override
        public S3Storage build() {
            return new S3Storage(this);
        }
    }
}
