/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the placement for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstancesPlacement implements
        ToCopyableBuilder<ScheduledInstancesPlacement.Builder, ScheduledInstancesPlacement> {
    private final String availabilityZone;

    private final String groupName;

    private ScheduledInstancesPlacement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.groupName = builder.groupName;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The name of the placement group.
     * </p>
     * 
     * @return The name of the placement group.
     */
    public String groupName() {
        return groupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesPlacement)) {
            return false;
        }
        ScheduledInstancesPlacement other = (ScheduledInstancesPlacement) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstancesPlacement> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The name of the placement group.
         * </p>
         * 
         * @param groupName
         *        The name of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesPlacement model) {
            setAvailabilityZone(model.availabilityZone);
            setGroupName(model.groupName);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public ScheduledInstancesPlacement build() {
            return new ScheduledInstancesPlacement(this);
        }
    }
}
