/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the target configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TargetConfigurationRequest implements
        ToCopyableBuilder<TargetConfigurationRequest.Builder, TargetConfigurationRequest> {
    private final Integer instanceCount;

    private final String offeringId;

    private TargetConfigurationRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is reserved
     * and cannot be specified in a request
     * </p>
     * 
     * @return The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is
     *         reserved and cannot be specified in a request
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The Convertible Reserved Instance offering ID.
     * </p>
     * 
     * @return The Convertible Reserved Instance offering ID.
     */
    public String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceCount() == null) ? 0 : instanceCount().hashCode());
        hashCode = 31 * hashCode + ((offeringId() == null) ? 0 : offeringId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetConfigurationRequest)) {
            return false;
        }
        TargetConfigurationRequest other = (TargetConfigurationRequest) obj;
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        if (other.offeringId() != null && !other.offeringId().equals(this.offeringId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (offeringId() != null) {
            sb.append("OfferingId: ").append(offeringId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TargetConfigurationRequest> {
        /**
         * <p>
         * The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is
         * reserved and cannot be specified in a request
         * </p>
         * 
         * @param instanceCount
         *        The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is
         *        reserved and cannot be specified in a request
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The Convertible Reserved Instance offering ID.
         * </p>
         * 
         * @param offeringId
         *        The Convertible Reserved Instance offering ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);
    }

    private static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetConfigurationRequest model) {
            setInstanceCount(model.instanceCount);
            setOfferingId(model.offeringId);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public TargetConfigurationRequest build() {
            return new TargetConfigurationRequest(this);
        }
    }
}
