/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about items that were not successfully processed in a batch call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnsuccessfulItem implements ToCopyableBuilder<UnsuccessfulItem.Builder, UnsuccessfulItem> {
    private final UnsuccessfulItemError error;

    private final String resourceId;

    private UnsuccessfulItem(BuilderImpl builder) {
        this.error = builder.error;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * Information about the error.
     * </p>
     * 
     * @return Information about the error.
     */
    public UnsuccessfulItemError error() {
        return error;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((error() == null) ? 0 : error().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsuccessfulItem)) {
            return false;
        }
        UnsuccessfulItem other = (UnsuccessfulItem) obj;
        if (other.error() == null ^ this.error() == null) {
            return false;
        }
        if (other.error() != null && !other.error().equals(this.error())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (error() != null) {
            sb.append("Error: ").append(error()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UnsuccessfulItem> {
        /**
         * <p>
         * Information about the error.
         * </p>
         * 
         * @param error
         *        Information about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(UnsuccessfulItemError error);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    private static final class BuilderImpl implements Builder {
        private UnsuccessfulItemError error;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsuccessfulItem model) {
            setError(model.error);
            setResourceId(model.resourceId);
        }

        public final UnsuccessfulItemError getError() {
            return error;
        }

        @Override
        public final Builder error(UnsuccessfulItemError error) {
            this.error = error;
            return this;
        }

        public final void setError(UnsuccessfulItemError error) {
            this.error = error;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public UnsuccessfulItem build() {
            return new UnsuccessfulItem(this);
        }
    }
}
