/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the error that occurred. For more information about errors, see <a
 * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">Error Codes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnsuccessfulItemError implements ToCopyableBuilder<UnsuccessfulItemError.Builder, UnsuccessfulItemError> {
    private final String code;

    private final String message;

    private UnsuccessfulItemError(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * The error message accompanying the error code.
     * </p>
     * 
     * @return The error message accompanying the error code.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((code() == null) ? 0 : code().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsuccessfulItemError)) {
            return false;
        }
        UnsuccessfulItemError other = (UnsuccessfulItemError) obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (code() != null) {
            sb.append("Code: ").append(code()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UnsuccessfulItemError> {
        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param code
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The error message accompanying the error code.
         * </p>
         * 
         * @param message
         *        The error message accompanying the error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsuccessfulItemError model) {
            setCode(model.code);
            setMessage(model.message);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public UnsuccessfulItemError build() {
            return new UnsuccessfulItemError(this);
        }
    }
}
