/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the S3 bucket for the disk image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UserBucketDetails implements ToCopyableBuilder<UserBucketDetails.Builder, UserBucketDetails> {
    private final String s3Bucket;

    private final String s3Key;

    private UserBucketDetails(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    /**
     * <p>
     * The S3 bucket from which the disk image was created.
     * </p>
     * 
     * @return The S3 bucket from which the disk image was created.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The file name of the disk image.
     * </p>
     * 
     * @return The file name of the disk image.
     */
    public String s3Key() {
        return s3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((s3Bucket() == null) ? 0 : s3Bucket().hashCode());
        hashCode = 31 * hashCode + ((s3Key() == null) ? 0 : s3Key().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserBucketDetails)) {
            return false;
        }
        UserBucketDetails other = (UserBucketDetails) obj;
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Key() == null ^ this.s3Key() == null) {
            return false;
        }
        if (other.s3Key() != null && !other.s3Key().equals(this.s3Key())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (s3Bucket() != null) {
            sb.append("S3Bucket: ").append(s3Bucket()).append(",");
        }
        if (s3Key() != null) {
            sb.append("S3Key: ").append(s3Key()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UserBucketDetails> {
        /**
         * <p>
         * The S3 bucket from which the disk image was created.
         * </p>
         * 
         * @param s3Bucket
         *        The S3 bucket from which the disk image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The file name of the disk image.
         * </p>
         * 
         * @param s3Key
         *        The file name of the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);
    }

    private static final class BuilderImpl implements Builder {
        private String s3Bucket;

        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(UserBucketDetails model) {
            setS3Bucket(model.s3Bucket);
            setS3Key(model.s3Key);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public UserBucketDetails build() {
            return new UserBucketDetails(this);
        }
    }
}
