/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeStatusDetails implements ToCopyableBuilder<VolumeStatusDetails.Builder, VolumeStatusDetails> {
    private final String name;

    private final String status;

    private VolumeStatusDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the volume status.
     * </p>
     * 
     * @return The name of the volume status.
     * @see VolumeStatusName
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The intended status of the volume status.
     * </p>
     * 
     * @return The intended status of the volume status.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusDetails)) {
            return false;
        }
        VolumeStatusDetails other = (VolumeStatusDetails) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeStatusDetails> {
        /**
         * <p>
         * The name of the volume status.
         * </p>
         * 
         * @param name
         *        The name of the volume status.
         * @see VolumeStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the volume status.
         * </p>
         * 
         * @param name
         *        The name of the volume status.
         * @see VolumeStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusName
         */
        Builder name(VolumeStatusName name);

        /**
         * <p>
         * The intended status of the volume status.
         * </p>
         * 
         * @param status
         *        The intended status of the volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusDetails model) {
            setName(model.name);
            setStatus(model.status);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(VolumeStatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public VolumeStatusDetails build() {
            return new VolumeStatusDetails(this);
        }
    }
}
