/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the volume status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeStatusItem implements ToCopyableBuilder<VolumeStatusItem.Builder, VolumeStatusItem> {
    private final List<VolumeStatusAction> actions;

    private final String availabilityZone;

    private final List<VolumeStatusEvent> events;

    private final String volumeId;

    private final VolumeStatusInfo volumeStatus;

    private VolumeStatusItem(BuilderImpl builder) {
        this.actions = builder.actions;
        this.availabilityZone = builder.availabilityZone;
        this.events = builder.events;
        this.volumeId = builder.volumeId;
        this.volumeStatus = builder.volumeStatus;
    }

    /**
     * <p>
     * The details of the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details of the operation.
     */
    public List<VolumeStatusAction> actions() {
        return actions;
    }

    /**
     * <p>
     * The Availability Zone of the volume.
     * </p>
     * 
     * @return The Availability Zone of the volume.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A list of events associated with the volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of events associated with the volume.
     */
    public List<VolumeStatusEvent> events() {
        return events;
    }

    /**
     * <p>
     * The volume ID.
     * </p>
     * 
     * @return The volume ID.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The volume status.
     * </p>
     * 
     * @return The volume status.
     */
    public VolumeStatusInfo volumeStatus() {
        return volumeStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((actions() == null) ? 0 : actions().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((volumeId() == null) ? 0 : volumeId().hashCode());
        hashCode = 31 * hashCode + ((volumeStatus() == null) ? 0 : volumeStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusItem)) {
            return false;
        }
        VolumeStatusItem other = (VolumeStatusItem) obj;
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        if (other.actions() != null && !other.actions().equals(this.actions())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.volumeStatus() == null ^ this.volumeStatus() == null) {
            return false;
        }
        if (other.volumeStatus() != null && !other.volumeStatus().equals(this.volumeStatus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (actions() != null) {
            sb.append("Actions: ").append(actions()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (volumeStatus() != null) {
            sb.append("VolumeStatus: ").append(volumeStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeStatusItem> {
        /**
         * <p>
         * The details of the operation.
         * </p>
         * 
         * @param actions
         *        The details of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<VolumeStatusAction> actions);

        /**
         * <p>
         * The details of the operation.
         * </p>
         * 
         * @param actions
         *        The details of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(VolumeStatusAction... actions);

        /**
         * <p>
         * The Availability Zone of the volume.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A list of events associated with the volume.
         * </p>
         * 
         * @param events
         *        A list of events associated with the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<VolumeStatusEvent> events);

        /**
         * <p>
         * A list of events associated with the volume.
         * </p>
         * 
         * @param events
         *        A list of events associated with the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(VolumeStatusEvent... events);

        /**
         * <p>
         * The volume ID.
         * </p>
         * 
         * @param volumeId
         *        The volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The volume status.
         * </p>
         * 
         * @param volumeStatus
         *        The volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatus(VolumeStatusInfo volumeStatus);
    }

    private static final class BuilderImpl implements Builder {
        private List<VolumeStatusAction> actions;

        private String availabilityZone;

        private List<VolumeStatusEvent> events;

        private String volumeId;

        private VolumeStatusInfo volumeStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusItem model) {
            setActions(model.actions);
            setAvailabilityZone(model.availabilityZone);
            setEvents(model.events);
            setVolumeId(model.volumeId);
            setVolumeStatus(model.volumeStatus);
        }

        public final Collection<VolumeStatusAction> getActions() {
            return actions;
        }

        @Override
        public final Builder actions(Collection<VolumeStatusAction> actions) {
            this.actions = VolumeStatusActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VolumeStatusAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<VolumeStatusAction> actions) {
            this.actions = VolumeStatusActionsListCopier.copy(actions);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<VolumeStatusEvent> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<VolumeStatusEvent> events) {
            this.events = VolumeStatusEventsListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(VolumeStatusEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<VolumeStatusEvent> events) {
            this.events = VolumeStatusEventsListCopier.copy(events);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final VolumeStatusInfo getVolumeStatus() {
            return volumeStatus;
        }

        @Override
        public final Builder volumeStatus(VolumeStatusInfo volumeStatus) {
            this.volumeStatus = volumeStatus;
            return this;
        }

        public final void setVolumeStatus(VolumeStatusInfo volumeStatus) {
            this.volumeStatus = volumeStatus;
        }

        @Override
        public VolumeStatusItem build() {
            return new VolumeStatusItem(this);
        }
    }
}
