/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Vpc implements ToCopyableBuilder<Vpc.Builder, Vpc> {
    private final String cidrBlock;

    private final String dhcpOptionsId;

    private final String state;

    private final String vpcId;

    private final String instanceTenancy;

    private final List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private final Boolean isDefault;

    private final List<Tag> tags;

    private Vpc(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.state = builder.state;
        this.vpcId = builder.vpcId;
        this.instanceTenancy = builder.instanceTenancy;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.isDefault = builder.isDefault;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The IPv4 CIDR block for the VPC.
     * </p>
     * 
     * @return The IPv4 CIDR block for the VPC.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The ID of the set of DHCP options you've associated with the VPC (or <code>default</code> if the default options
     * are associated with the VPC).
     * </p>
     * 
     * @return The ID of the set of DHCP options you've associated with the VPC (or <code>default</code> if the default
     *         options are associated with the VPC).
     */
    public String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    /**
     * <p>
     * The current state of the VPC.
     * </p>
     * 
     * @return The current state of the VPC.
     * @see VpcState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The allowed tenancy of instances launched into the VPC.
     * </p>
     * 
     * @return The allowed tenancy of instances launched into the VPC.
     * @see Tenancy
     */
    public String instanceTenancy() {
        return instanceTenancy;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR blocks associated with the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the IPv6 CIDR blocks associated with the VPC.
     */
    public List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet;
    }

    /**
     * <p>
     * Indicates whether the VPC is the default VPC.
     * </p>
     * 
     * @return Indicates whether the VPC is the default VPC.
     */
    public Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * Any tags assigned to the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the VPC.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cidrBlock() == null) ? 0 : cidrBlock().hashCode());
        hashCode = 31 * hashCode + ((dhcpOptionsId() == null) ? 0 : dhcpOptionsId().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        hashCode = 31 * hashCode + ((instanceTenancy() == null) ? 0 : instanceTenancy().hashCode());
        hashCode = 31 * hashCode + ((ipv6CidrBlockAssociationSet() == null) ? 0 : ipv6CidrBlockAssociationSet().hashCode());
        hashCode = 31 * hashCode + ((isDefault() == null) ? 0 : isDefault().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc) obj;
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.dhcpOptionsId() == null ^ this.dhcpOptionsId() == null) {
            return false;
        }
        if (other.dhcpOptionsId() != null && !other.dhcpOptionsId().equals(this.dhcpOptionsId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        if (other.ipv6CidrBlockAssociationSet() == null ^ this.ipv6CidrBlockAssociationSet() == null) {
            return false;
        }
        if (other.ipv6CidrBlockAssociationSet() != null
                && !other.ipv6CidrBlockAssociationSet().equals(this.ipv6CidrBlockAssociationSet())) {
            return false;
        }
        if (other.isDefault() == null ^ this.isDefault() == null) {
            return false;
        }
        if (other.isDefault() != null && !other.isDefault().equals(this.isDefault())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (dhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: ").append(dhcpOptionsId()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(instanceTenancy()).append(",");
        }
        if (ipv6CidrBlockAssociationSet() != null) {
            sb.append("Ipv6CidrBlockAssociationSet: ").append(ipv6CidrBlockAssociationSet()).append(",");
        }
        if (isDefault() != null) {
            sb.append("IsDefault: ").append(isDefault()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Vpc> {
        /**
         * <p>
         * The IPv4 CIDR block for the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The ID of the set of DHCP options you've associated with the VPC (or <code>default</code> if the default
         * options are associated with the VPC).
         * </p>
         * 
         * @param dhcpOptionsId
         *        The ID of the set of DHCP options you've associated with the VPC (or <code>default</code> if the
         *        default options are associated with the VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);

        /**
         * <p>
         * The current state of the VPC.
         * </p>
         * 
         * @param state
         *        The current state of the VPC.
         * @see VpcState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the VPC.
         * </p>
         * 
         * @param state
         *        The current state of the VPC.
         * @see VpcState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcState
         */
        Builder state(VpcState state);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The allowed tenancy of instances launched into the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The allowed tenancy of instances launched into the VPC.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The allowed tenancy of instances launched into the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The allowed tenancy of instances launched into the VPC.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Indicates whether the VPC is the default VPC.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether the VPC is the default VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private String dhcpOptionsId;

        private String state;

        private String vpcId;

        private String instanceTenancy;

        private List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

        private Boolean isDefault;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Vpc model) {
            setCidrBlock(model.cidrBlock);
            setDhcpOptionsId(model.dhcpOptionsId);
            setState(model.state);
            setVpcId(model.vpcId);
            setInstanceTenancy(model.instanceTenancy);
            setIpv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            setIsDefault(model.isDefault);
            setTags(model.tags);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Collection<VpcIpv6CidrBlockAssociation> getIpv6CidrBlockAssociationSet() {
            return ipv6CidrBlockAssociationSet;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        public Vpc build() {
            return new Vpc(this);
        }
    }
}
