/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcEndpoint implements ToCopyableBuilder<VpcEndpoint.Builder, VpcEndpoint> {
    private final Instant creationTimestamp;

    private final String policyDocument;

    private final List<String> routeTableIds;

    private final String serviceName;

    private final String state;

    private final String vpcEndpointId;

    private final String vpcId;

    private VpcEndpoint(BuilderImpl builder) {
        this.creationTimestamp = builder.creationTimestamp;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.serviceName = builder.serviceName;
        this.state = builder.state;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The date and time the VPC endpoint was created.
     * </p>
     * 
     * @return The date and time the VPC endpoint was created.
     */
    public Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The policy document associated with the endpoint.
     * </p>
     * 
     * @return The policy document associated with the endpoint.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * One or more route tables associated with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more route tables associated with the endpoint.
     */
    public List<String> routeTableIds() {
        return routeTableIds;
    }

    /**
     * <p>
     * The name of the AWS service to which the endpoint is associated.
     * </p>
     * 
     * @return The name of the AWS service to which the endpoint is associated.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The state of the VPC endpoint.
     * </p>
     * 
     * @return The state of the VPC endpoint.
     * @see State
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The ID of the VPC endpoint.
     * </p>
     * 
     * @return The ID of the VPC endpoint.
     */
    public String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The ID of the VPC to which the endpoint is associated.
     * </p>
     * 
     * @return The ID of the VPC to which the endpoint is associated.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((creationTimestamp() == null) ? 0 : creationTimestamp().hashCode());
        hashCode = 31 * hashCode + ((policyDocument() == null) ? 0 : policyDocument().hashCode());
        hashCode = 31 * hashCode + ((routeTableIds() == null) ? 0 : routeTableIds().hashCode());
        hashCode = 31 * hashCode + ((serviceName() == null) ? 0 : serviceName().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((vpcEndpointId() == null) ? 0 : vpcEndpointId().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint) obj;
        if (other.creationTimestamp() == null ^ this.creationTimestamp() == null) {
            return false;
        }
        if (other.creationTimestamp() != null && !other.creationTimestamp().equals(this.creationTimestamp())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.routeTableIds() == null ^ this.routeTableIds() == null) {
            return false;
        }
        if (other.routeTableIds() != null && !other.routeTableIds().equals(this.routeTableIds())) {
            return false;
        }
        if (other.serviceName() == null ^ this.serviceName() == null) {
            return false;
        }
        if (other.serviceName() != null && !other.serviceName().equals(this.serviceName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.vpcEndpointId() == null ^ this.vpcEndpointId() == null) {
            return false;
        }
        if (other.vpcEndpointId() != null && !other.vpcEndpointId().equals(this.vpcEndpointId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (creationTimestamp() != null) {
            sb.append("CreationTimestamp: ").append(creationTimestamp()).append(",");
        }
        if (policyDocument() != null) {
            sb.append("PolicyDocument: ").append(policyDocument()).append(",");
        }
        if (routeTableIds() != null) {
            sb.append("RouteTableIds: ").append(routeTableIds()).append(",");
        }
        if (serviceName() != null) {
            sb.append("ServiceName: ").append(serviceName()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (vpcEndpointId() != null) {
            sb.append("VpcEndpointId: ").append(vpcEndpointId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VpcEndpoint> {
        /**
         * <p>
         * The date and time the VPC endpoint was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The date and time the VPC endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The policy document associated with the endpoint.
         * </p>
         * 
         * @param policyDocument
         *        The policy document associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * One or more route tables associated with the endpoint.
         * </p>
         * 
         * @param routeTableIds
         *        One or more route tables associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(Collection<String> routeTableIds);

        /**
         * <p>
         * One or more route tables associated with the endpoint.
         * </p>
         * 
         * @param routeTableIds
         *        One or more route tables associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(String... routeTableIds);

        /**
         * <p>
         * The name of the AWS service to which the endpoint is associated.
         * </p>
         * 
         * @param serviceName
         *        The name of the AWS service to which the endpoint is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The state of the VPC endpoint.
         * </p>
         * 
         * @param state
         *        The state of the VPC endpoint.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the VPC endpoint.
         * </p>
         * 
         * @param state
         *        The state of the VPC endpoint.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * The ID of the VPC endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The ID of the VPC to which the endpoint is associated.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC to which the endpoint is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private Instant creationTimestamp;

        private String policyDocument;

        private List<String> routeTableIds;

        private String serviceName;

        private String state;

        private String vpcEndpointId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpoint model) {
            setCreationTimestamp(model.creationTimestamp);
            setPolicyDocument(model.policyDocument);
            setRouteTableIds(model.routeTableIds);
            setServiceName(model.serviceName);
            setState(model.state);
            setVpcEndpointId(model.vpcEndpointId);
            setVpcId(model.vpcId);
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRouteTableIds() {
            return routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String... routeTableIds) {
            routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public VpcEndpoint build() {
            return new VpcEndpoint(this);
        }
    }
}
