/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a static route for a VPN connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpnStaticRoute implements ToCopyableBuilder<VpnStaticRoute.Builder, VpnStaticRoute> {
    private final String destinationCidrBlock;

    private final String source;

    private final String state;

    private VpnStaticRoute(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.source = builder.source;
        this.state = builder.state;
    }

    /**
     * <p>
     * The CIDR block associated with the local subnet of the customer data center.
     * </p>
     * 
     * @return The CIDR block associated with the local subnet of the customer data center.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * Indicates how the routes were provided.
     * </p>
     * 
     * @return Indicates how the routes were provided.
     * @see VpnStaticRouteSource
     */
    public String source() {
        return source;
    }

    /**
     * <p>
     * The current state of the static route.
     * </p>
     * 
     * @return The current state of the static route.
     * @see VpnState
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationCidrBlock() == null) ? 0 : destinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + ((source() == null) ? 0 : source().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnStaticRoute)) {
            return false;
        }
        VpnStaticRoute other = (VpnStaticRoute) obj;
        if (other.destinationCidrBlock() == null ^ this.destinationCidrBlock() == null) {
            return false;
        }
        if (other.destinationCidrBlock() != null && !other.destinationCidrBlock().equals(this.destinationCidrBlock())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(destinationCidrBlock()).append(",");
        }
        if (source() != null) {
            sb.append("Source: ").append(source()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VpnStaticRoute> {
        /**
         * <p>
         * The CIDR block associated with the local subnet of the customer data center.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The CIDR block associated with the local subnet of the customer data center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * Indicates how the routes were provided.
         * </p>
         * 
         * @param source
         *        Indicates how the routes were provided.
         * @see VpnStaticRouteSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnStaticRouteSource
         */
        Builder source(String source);

        /**
         * <p>
         * Indicates how the routes were provided.
         * </p>
         * 
         * @param source
         *        Indicates how the routes were provided.
         * @see VpnStaticRouteSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnStaticRouteSource
         */
        Builder source(VpnStaticRouteSource source);

        /**
         * <p>
         * The current state of the static route.
         * </p>
         * 
         * @param state
         *        The current state of the static route.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the static route.
         * </p>
         * 
         * @param state
         *        The current state of the static route.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(VpnState state);
    }

    private static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String source;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnStaticRoute model) {
            setDestinationCidrBlock(model.destinationCidrBlock);
            setSource(model.source);
            setState(model.state);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(VpnStaticRouteSource source) {
            this.source(source.toString());
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public VpnStaticRoute build() {
            return new VpnStaticRoute(this);
        }
    }
}
