/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * AssignIpv6AddressesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AssignIpv6AddressesRequestMarshaller implements
        Marshaller<Request<AssignIpv6AddressesRequest>, AssignIpv6AddressesRequest> {

    public Request<AssignIpv6AddressesRequest> marshall(AssignIpv6AddressesRequest assignIpv6AddressesRequest) {

        if (assignIpv6AddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AssignIpv6AddressesRequest> request = new DefaultRequest<AssignIpv6AddressesRequest>(assignIpv6AddressesRequest,
                "EC2Client");
        request.addParameter("Action", "AssignIpv6Addresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (assignIpv6AddressesRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger(assignIpv6AddressesRequest.ipv6AddressCount()));
        }

        java.util.List<String> assignIpv6AddressesRequestIpv6AddressesList = assignIpv6AddressesRequest.ipv6Addresses();
        if (assignIpv6AddressesRequestIpv6AddressesList != null) {
            int ipv6AddressesListIndex = 1;

            for (String assignIpv6AddressesRequestIpv6AddressesListValue : assignIpv6AddressesRequestIpv6AddressesList) {
                if (assignIpv6AddressesRequestIpv6AddressesListValue != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex,
                            StringUtils.fromString(assignIpv6AddressesRequestIpv6AddressesListValue));
                }
                ipv6AddressesListIndex++;
            }
        }

        if (assignIpv6AddressesRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(assignIpv6AddressesRequest.networkInterfaceId()));
        }

        return request;
    }

}
