/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeFlowLogsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeFlowLogsResponseUnmarshaller implements Unmarshaller<DescribeFlowLogsResponse, StaxUnmarshallerContext> {

    public DescribeFlowLogsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeFlowLogsResponse.Builder describeFlowLogsResponse = DescribeFlowLogsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<FlowLog> flowLogs = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeFlowLogsResponse.flowLogs(flowLogs);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("flowLogSet", targetDepth)) {
                    flowLogs = new ArrayList<FlowLog>();
                    continue;
                }

                if (context.testExpression("flowLogSet/item", targetDepth)) {
                    flowLogs.add(FlowLogUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeFlowLogsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeFlowLogsResponse.flowLogs(flowLogs);
                    break;
                }
            }
        }
        return describeFlowLogsResponse.build();
    }

    private static final DescribeFlowLogsResponseUnmarshaller INSTANCE = new DescribeFlowLogsResponseUnmarshaller();

    public static DescribeFlowLogsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
