/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeFpgaImagesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeFpgaImagesRequestMarshaller implements
        Marshaller<Request<DescribeFpgaImagesRequest>, DescribeFpgaImagesRequest> {

    public Request<DescribeFpgaImagesRequest> marshall(DescribeFpgaImagesRequest describeFpgaImagesRequest) {

        if (describeFpgaImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeFpgaImagesRequest> request = new DefaultRequest<DescribeFpgaImagesRequest>(describeFpgaImagesRequest,
                "EC2Client");
        request.addParameter("Action", "DescribeFpgaImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> describeFpgaImagesRequestFpgaImageIdsList = describeFpgaImagesRequest.fpgaImageIds();
        if (describeFpgaImagesRequestFpgaImageIdsList != null) {
            int fpgaImageIdsListIndex = 1;

            for (String describeFpgaImagesRequestFpgaImageIdsListValue : describeFpgaImagesRequestFpgaImageIdsList) {
                if (describeFpgaImagesRequestFpgaImageIdsListValue != null) {
                    request.addParameter("FpgaImageId." + fpgaImageIdsListIndex,
                            StringUtils.fromString(describeFpgaImagesRequestFpgaImageIdsListValue));
                }
                fpgaImageIdsListIndex++;
            }
        }

        java.util.List<String> describeFpgaImagesRequestOwnersList = describeFpgaImagesRequest.owners();
        if (describeFpgaImagesRequestOwnersList != null) {
            int ownersListIndex = 1;

            for (String describeFpgaImagesRequestOwnersListValue : describeFpgaImagesRequestOwnersList) {
                if (describeFpgaImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex,
                            StringUtils.fromString(describeFpgaImagesRequestOwnersListValue));
                }
                ownersListIndex++;
            }
        }

        java.util.List<Filter> describeFpgaImagesRequestFiltersList = describeFpgaImagesRequest.filters();
        if (describeFpgaImagesRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeFpgaImagesRequestFiltersListValue : describeFpgaImagesRequestFiltersList) {

                if (describeFpgaImagesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeFpgaImagesRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeFpgaImagesRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeFpgaImagesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeFpgaImagesRequest.nextToken()));
        }

        if (describeFpgaImagesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeFpgaImagesRequest.maxResults()));
        }

        return request;
    }

}
