/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeReservedInstancesOfferingsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeReservedInstancesOfferingsRequestMarshaller implements
        Marshaller<Request<DescribeReservedInstancesOfferingsRequest>, DescribeReservedInstancesOfferingsRequest> {

    public Request<DescribeReservedInstancesOfferingsRequest> marshall(
            DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {

        if (describeReservedInstancesOfferingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeReservedInstancesOfferingsRequest> request = new DefaultRequest<DescribeReservedInstancesOfferingsRequest>(
                describeReservedInstancesOfferingsRequest, "EC2Client");
        request.addParameter("Action", "DescribeReservedInstancesOfferings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeReservedInstancesOfferingsRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone",
                    StringUtils.fromString(describeReservedInstancesOfferingsRequest.availabilityZone()));
        }

        java.util.List<Filter> describeReservedInstancesOfferingsRequestFiltersList = describeReservedInstancesOfferingsRequest
                .filters();
        if (describeReservedInstancesOfferingsRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeReservedInstancesOfferingsRequestFiltersListValue : describeReservedInstancesOfferingsRequestFiltersList) {

                if (describeReservedInstancesOfferingsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeReservedInstancesOfferingsRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeReservedInstancesOfferingsRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeReservedInstancesOfferingsRequest.includeMarketplace() != null) {
            request.addParameter("IncludeMarketplace",
                    StringUtils.fromBoolean(describeReservedInstancesOfferingsRequest.includeMarketplace()));
        }

        if (describeReservedInstancesOfferingsRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(describeReservedInstancesOfferingsRequest.instanceType()));
        }

        if (describeReservedInstancesOfferingsRequest.maxDuration() != null) {
            request.addParameter("MaxDuration", StringUtils.fromLong(describeReservedInstancesOfferingsRequest.maxDuration()));
        }

        if (describeReservedInstancesOfferingsRequest.maxInstanceCount() != null) {
            request.addParameter("MaxInstanceCount",
                    StringUtils.fromInteger(describeReservedInstancesOfferingsRequest.maxInstanceCount()));
        }

        if (describeReservedInstancesOfferingsRequest.minDuration() != null) {
            request.addParameter("MinDuration", StringUtils.fromLong(describeReservedInstancesOfferingsRequest.minDuration()));
        }

        if (describeReservedInstancesOfferingsRequest.offeringClass() != null) {
            request.addParameter("OfferingClass",
                    StringUtils.fromString(describeReservedInstancesOfferingsRequest.offeringClass()));
        }

        if (describeReservedInstancesOfferingsRequest.productDescription() != null) {
            request.addParameter("ProductDescription",
                    StringUtils.fromString(describeReservedInstancesOfferingsRequest.productDescription()));
        }

        java.util.List<String> describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList = describeReservedInstancesOfferingsRequest
                .reservedInstancesOfferingIds();
        if (describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList != null) {
            int reservedInstancesOfferingIdsListIndex = 1;

            for (String describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue : describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList) {
                if (describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue != null) {
                    request.addParameter("ReservedInstancesOfferingId." + reservedInstancesOfferingIdsListIndex, StringUtils
                            .fromString(describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue));
                }
                reservedInstancesOfferingIdsListIndex++;
            }
        }

        if (describeReservedInstancesOfferingsRequest.instanceTenancy() != null) {
            request.addParameter("InstanceTenancy",
                    StringUtils.fromString(describeReservedInstancesOfferingsRequest.instanceTenancy()));
        }

        if (describeReservedInstancesOfferingsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeReservedInstancesOfferingsRequest.maxResults()));
        }

        if (describeReservedInstancesOfferingsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeReservedInstancesOfferingsRequest.nextToken()));
        }

        if (describeReservedInstancesOfferingsRequest.offeringType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString(describeReservedInstancesOfferingsRequest.offeringType()));
        }

        return request;
    }

}
