/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeSpotInstanceRequestsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSpotInstanceRequestsResponseUnmarshaller implements
        Unmarshaller<DescribeSpotInstanceRequestsResponse, StaxUnmarshallerContext> {

    public DescribeSpotInstanceRequestsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeSpotInstanceRequestsResponse.Builder describeSpotInstanceRequestsResponse = DescribeSpotInstanceRequestsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<SpotInstanceRequest> spotInstanceRequests = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeSpotInstanceRequestsResponse.spotInstanceRequests(spotInstanceRequests);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("spotInstanceRequestSet", targetDepth)) {
                    spotInstanceRequests = new ArrayList<SpotInstanceRequest>();
                    continue;
                }

                if (context.testExpression("spotInstanceRequestSet/item", targetDepth)) {
                    spotInstanceRequests.add(SpotInstanceRequestUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeSpotInstanceRequestsResponse.spotInstanceRequests(spotInstanceRequests);
                    break;
                }
            }
        }
        return describeSpotInstanceRequestsResponse.build();
    }

    private static final DescribeSpotInstanceRequestsResponseUnmarshaller INSTANCE = new DescribeSpotInstanceRequestsResponseUnmarshaller();

    public static DescribeSpotInstanceRequestsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
