/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetReservedInstancesExchangeQuoteResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetReservedInstancesExchangeQuoteResponseUnmarshaller implements
        Unmarshaller<GetReservedInstancesExchangeQuoteResponse, StaxUnmarshallerContext> {

    public GetReservedInstancesExchangeQuoteResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetReservedInstancesExchangeQuoteResponse.Builder getReservedInstancesExchangeQuoteResponse = GetReservedInstancesExchangeQuoteResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ReservedInstanceReservationValue> reservedInstanceValueSet = null;
        java.util.List<TargetReservationValue> targetConfigurationValueSet = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getReservedInstancesExchangeQuoteResponse.reservedInstanceValueSet(reservedInstanceValueSet);
                getReservedInstancesExchangeQuoteResponse.targetConfigurationValueSet(targetConfigurationValueSet);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("currencyCode", targetDepth)) {
                    getReservedInstancesExchangeQuoteResponse.currencyCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("isValidExchange", targetDepth)) {
                    getReservedInstancesExchangeQuoteResponse.isValidExchange(BooleanUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("outputReservedInstancesWillExpireAt", targetDepth)) {
                    getReservedInstancesExchangeQuoteResponse.outputReservedInstancesWillExpireAt(InstantUnmarshaller
                            .getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("paymentDue", targetDepth)) {
                    getReservedInstancesExchangeQuoteResponse.paymentDue(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservedInstanceValueRollup", targetDepth)) {
                    getReservedInstancesExchangeQuoteResponse.reservedInstanceValueRollup(ReservationValueUnmarshaller
                            .getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservedInstanceValueSet", targetDepth)) {
                    reservedInstanceValueSet = new ArrayList<ReservedInstanceReservationValue>();
                    continue;
                }

                if (context.testExpression("reservedInstanceValueSet/item", targetDepth)) {
                    reservedInstanceValueSet.add(ReservedInstanceReservationValueUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("targetConfigurationValueRollup", targetDepth)) {
                    getReservedInstancesExchangeQuoteResponse.targetConfigurationValueRollup(ReservationValueUnmarshaller
                            .getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("targetConfigurationValueSet", targetDepth)) {
                    targetConfigurationValueSet = new ArrayList<TargetReservationValue>();
                    continue;
                }

                if (context.testExpression("targetConfigurationValueSet/item", targetDepth)) {
                    targetConfigurationValueSet.add(TargetReservationValueUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("validationFailureReason", targetDepth)) {
                    getReservedInstancesExchangeQuoteResponse.validationFailureReason(StringUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getReservedInstancesExchangeQuoteResponse.reservedInstanceValueSet(reservedInstanceValueSet);
                    getReservedInstancesExchangeQuoteResponse.targetConfigurationValueSet(targetConfigurationValueSet);
                    break;
                }
            }
        }
        return getReservedInstancesExchangeQuoteResponse.build();
    }

    private static final GetReservedInstancesExchangeQuoteResponseUnmarshaller INSTANCE = new GetReservedInstancesExchangeQuoteResponseUnmarshaller();

    public static GetReservedInstancesExchangeQuoteResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
