/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ImageAttribute StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImageAttributeUnmarshaller implements Unmarshaller<ImageAttribute, StaxUnmarshallerContext> {

    public ImageAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        ImageAttribute.Builder imageAttribute = ImageAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<BlockDeviceMapping> blockDeviceMappings = null;
        java.util.List<LaunchPermission> launchPermissions = null;
        java.util.List<ProductCode> productCodes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                imageAttribute.blockDeviceMappings(blockDeviceMappings);
                imageAttribute.launchPermissions(launchPermissions);
                imageAttribute.productCodes(productCodes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                    continue;
                }

                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageId", targetDepth)) {
                    imageAttribute.imageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("launchPermission", targetDepth)) {
                    launchPermissions = new ArrayList<LaunchPermission>();
                    continue;
                }

                if (context.testExpression("launchPermission/item", targetDepth)) {
                    launchPermissions.add(LaunchPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productCodes", targetDepth)) {
                    productCodes = new ArrayList<ProductCode>();
                    continue;
                }

                if (context.testExpression("productCodes/item", targetDepth)) {
                    productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("description/value", targetDepth)) {
                    imageAttribute.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("kernel/value", targetDepth)) {
                    imageAttribute.kernelId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ramdisk/value", targetDepth)) {
                    imageAttribute.ramdiskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sriovNetSupport/value", targetDepth)) {
                    imageAttribute.sriovNetSupport(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    imageAttribute.blockDeviceMappings(blockDeviceMappings);
                    imageAttribute.launchPermissions(launchPermissions);
                    imageAttribute.productCodes(productCodes);
                    break;
                }
            }
        }
        return imageAttribute.build();
    }

    private static final ImageAttributeUnmarshaller INSTANCE = new ImageAttributeUnmarshaller();

    public static ImageAttributeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
