/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * InstanceNetworkInterfaceSpecification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceNetworkInterfaceSpecificationUnmarshaller implements
        Unmarshaller<InstanceNetworkInterfaceSpecification, StaxUnmarshallerContext> {

    public InstanceNetworkInterfaceSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceNetworkInterfaceSpecification.Builder instanceNetworkInterfaceSpecification = InstanceNetworkInterfaceSpecification
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> groups = null;
        java.util.List<InstanceIpv6Address> ipv6Addresses = null;
        java.util.List<PrivateIpAddressSpecification> privateIpAddresses = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                instanceNetworkInterfaceSpecification.groups(groups);
                instanceNetworkInterfaceSpecification.ipv6Addresses(ipv6Addresses);
                instanceNetworkInterfaceSpecification.privateIpAddresses(privateIpAddresses);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("associatePublicIpAddress", targetDepth)) {
                    instanceNetworkInterfaceSpecification.associatePublicIpAddress(BooleanUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("deleteOnTermination", targetDepth)) {
                    instanceNetworkInterfaceSpecification.deleteOnTermination(BooleanUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("description", targetDepth)) {
                    instanceNetworkInterfaceSpecification.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("deviceIndex", targetDepth)) {
                    instanceNetworkInterfaceSpecification.deviceIndex(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SecurityGroupId", targetDepth)) {
                    groups = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("SecurityGroupId/SecurityGroupId", targetDepth)) {
                    groups.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6AddressCount", targetDepth)) {
                    instanceNetworkInterfaceSpecification.ipv6AddressCount(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6AddressesSet", targetDepth)) {
                    ipv6Addresses = new ArrayList<InstanceIpv6Address>();
                    continue;
                }

                if (context.testExpression("ipv6AddressesSet/item", targetDepth)) {
                    ipv6Addresses.add(InstanceIpv6AddressUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceId", targetDepth)) {
                    instanceNetworkInterfaceSpecification
                            .networkInterfaceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateIpAddress", targetDepth)) {
                    instanceNetworkInterfaceSpecification.privateIpAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateIpAddressesSet", targetDepth)) {
                    privateIpAddresses = new ArrayList<PrivateIpAddressSpecification>();
                    continue;
                }

                if (context.testExpression("privateIpAddressesSet/item", targetDepth)) {
                    privateIpAddresses.add(PrivateIpAddressSpecificationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("secondaryPrivateIpAddressCount", targetDepth)) {
                    instanceNetworkInterfaceSpecification.secondaryPrivateIpAddressCount(IntegerUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetId", targetDepth)) {
                    instanceNetworkInterfaceSpecification.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    instanceNetworkInterfaceSpecification.groups(groups);
                    instanceNetworkInterfaceSpecification.ipv6Addresses(ipv6Addresses);
                    instanceNetworkInterfaceSpecification.privateIpAddresses(privateIpAddresses);
                    break;
                }
            }
        }
        return instanceNetworkInterfaceSpecification.build();
    }

    private static final InstanceNetworkInterfaceSpecificationUnmarshaller INSTANCE = new InstanceNetworkInterfaceSpecificationUnmarshaller();

    public static InstanceNetworkInterfaceSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
