/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * ReplaceRouteRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReplaceRouteRequestMarshaller implements Marshaller<Request<ReplaceRouteRequest>, ReplaceRouteRequest> {

    public Request<ReplaceRouteRequest> marshall(ReplaceRouteRequest replaceRouteRequest) {

        if (replaceRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ReplaceRouteRequest> request = new DefaultRequest<ReplaceRouteRequest>(replaceRouteRequest, "EC2Client");
        request.addParameter("Action", "ReplaceRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (replaceRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(replaceRouteRequest.destinationCidrBlock()));
        }

        if (replaceRouteRequest.destinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock",
                    StringUtils.fromString(replaceRouteRequest.destinationIpv6CidrBlock()));
        }

        if (replaceRouteRequest.egressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId",
                    StringUtils.fromString(replaceRouteRequest.egressOnlyInternetGatewayId()));
        }

        if (replaceRouteRequest.gatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString(replaceRouteRequest.gatewayId()));
        }

        if (replaceRouteRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(replaceRouteRequest.instanceId()));
        }

        if (replaceRouteRequest.natGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString(replaceRouteRequest.natGatewayId()));
        }

        if (replaceRouteRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(replaceRouteRequest.networkInterfaceId()));
        }

        if (replaceRouteRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString(replaceRouteRequest.routeTableId()));
        }

        if (replaceRouteRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString(replaceRouteRequest.vpcPeeringConnectionId()));
        }

        return request;
    }

}
