/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * RevokeSecurityGroupIngressRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RevokeSecurityGroupIngressRequestMarshaller implements
        Marshaller<Request<RevokeSecurityGroupIngressRequest>, RevokeSecurityGroupIngressRequest> {

    public Request<RevokeSecurityGroupIngressRequest> marshall(RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) {

        if (revokeSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<RevokeSecurityGroupIngressRequest> request = new DefaultRequest<RevokeSecurityGroupIngressRequest>(
                revokeSecurityGroupIngressRequest, "EC2Client");
        request.addParameter("Action", "RevokeSecurityGroupIngress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (revokeSecurityGroupIngressRequest.cidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString(revokeSecurityGroupIngressRequest.cidrIp()));
        }

        if (revokeSecurityGroupIngressRequest.fromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequest.fromPort()));
        }

        if (revokeSecurityGroupIngressRequest.groupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString(revokeSecurityGroupIngressRequest.groupId()));
        }

        if (revokeSecurityGroupIngressRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(revokeSecurityGroupIngressRequest.groupName()));
        }

        java.util.List<IpPermission> revokeSecurityGroupIngressRequestIpPermissionsList = revokeSecurityGroupIngressRequest
                .ipPermissions();
        if (revokeSecurityGroupIngressRequestIpPermissionsList != null) {
            int ipPermissionsListIndex = 1;

            for (IpPermission revokeSecurityGroupIngressRequestIpPermissionsListValue : revokeSecurityGroupIngressRequestIpPermissionsList) {

                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.fromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort",
                            StringUtils.fromInteger(revokeSecurityGroupIngressRequestIpPermissionsListValue.fromPort()));
                }

                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.ipProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol",
                            StringUtils.fromString(revokeSecurityGroupIngressRequestIpPermissionsListValue.ipProtocol()));
                }

                java.util.List<Ipv6Range> ipPermissionIpv6RangesList = revokeSecurityGroupIngressRequestIpPermissionsListValue
                        .ipv6Ranges();
                if (ipPermissionIpv6RangesList != null) {
                    int ipv6RangesListIndex = 1;

                    for (Ipv6Range ipPermissionIpv6RangesListValue : ipPermissionIpv6RangesList) {

                        if (ipPermissionIpv6RangesListValue.cidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex
                                    + ".CidrIpv6", StringUtils.fromString(ipPermissionIpv6RangesListValue.cidrIpv6()));
                        }
                        ipv6RangesListIndex++;
                    }
                }

                java.util.List<PrefixListId> ipPermissionPrefixListIdsList = revokeSecurityGroupIngressRequestIpPermissionsListValue
                        .prefixListIds();
                if (ipPermissionPrefixListIdsList != null) {
                    int prefixListIdsListIndex = 1;

                    for (PrefixListId ipPermissionPrefixListIdsListValue : ipPermissionPrefixListIdsList) {

                        if (ipPermissionPrefixListIdsListValue.prefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds."
                                    + prefixListIdsListIndex + ".PrefixListId",
                                    StringUtils.fromString(ipPermissionPrefixListIdsListValue.prefixListId()));
                        }
                        prefixListIdsListIndex++;
                    }
                }

                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.toPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort",
                            StringUtils.fromInteger(revokeSecurityGroupIngressRequestIpPermissionsListValue.toPort()));
                }

                java.util.List<UserIdGroupPair> ipPermissionUserIdGroupPairsList = revokeSecurityGroupIngressRequestIpPermissionsListValue
                        .userIdGroupPairs();
                if (ipPermissionUserIdGroupPairsList != null) {
                    int userIdGroupPairsListIndex = 1;

                    for (UserIdGroupPair ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {

                        if (ipPermissionUserIdGroupPairsListValue.groupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".GroupId",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.groupId()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.groupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".GroupName",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.groupName()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.peeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".PeeringStatus",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.peeringStatus()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.userId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".UserId",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.userId()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.vpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".VpcId",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.vpcId()));
                        }

                        if (ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups."
                                    + userIdGroupPairsListIndex + ".VpcPeeringConnectionId",
                                    StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId()));
                        }
                        userIdGroupPairsListIndex++;
                    }
                }

                java.util.List<IpRange> ipPermissionIpv4RangesList = revokeSecurityGroupIngressRequestIpPermissionsListValue
                        .ipv4Ranges();
                if (ipPermissionIpv4RangesList != null) {
                    int ipv4RangesListIndex = 1;

                    for (IpRange ipPermissionIpv4RangesListValue : ipPermissionIpv4RangesList) {

                        if (ipPermissionIpv4RangesListValue.cidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex
                                    + ".CidrIp", StringUtils.fromString(ipPermissionIpv4RangesListValue.cidrIp()));
                        }
                        ipv4RangesListIndex++;
                    }
                }
                ipPermissionsListIndex++;
            }
        }

        if (revokeSecurityGroupIngressRequest.ipProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString(revokeSecurityGroupIngressRequest.ipProtocol()));
        }

        if (revokeSecurityGroupIngressRequest.sourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName",
                    StringUtils.fromString(revokeSecurityGroupIngressRequest.sourceSecurityGroupName()));
        }

        if (revokeSecurityGroupIngressRequest.sourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId",
                    StringUtils.fromString(revokeSecurityGroupIngressRequest.sourceSecurityGroupOwnerId()));
        }

        if (revokeSecurityGroupIngressRequest.toPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequest.toPort()));
        }

        return request;
    }

}
