/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * SpotFleetLaunchSpecification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SpotFleetLaunchSpecificationUnmarshaller implements
        Unmarshaller<SpotFleetLaunchSpecification, StaxUnmarshallerContext> {

    public SpotFleetLaunchSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        SpotFleetLaunchSpecification.Builder spotFleetLaunchSpecification = SpotFleetLaunchSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<GroupIdentifier> securityGroups = null;
        java.util.List<BlockDeviceMapping> blockDeviceMappings = null;
        java.util.List<InstanceNetworkInterfaceSpecification> networkInterfaces = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                spotFleetLaunchSpecification.securityGroups(securityGroups);
                spotFleetLaunchSpecification.blockDeviceMappings(blockDeviceMappings);
                spotFleetLaunchSpecification.networkInterfaces(networkInterfaces);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("groupSet", targetDepth)) {
                    securityGroups = new ArrayList<GroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    securityGroups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("addressingType", targetDepth)) {
                    spotFleetLaunchSpecification.addressingType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                    continue;
                }

                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ebsOptimized", targetDepth)) {
                    spotFleetLaunchSpecification.ebsOptimized(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("iamInstanceProfile", targetDepth)) {
                    spotFleetLaunchSpecification.iamInstanceProfile(IamInstanceProfileSpecificationUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageId", targetDepth)) {
                    spotFleetLaunchSpecification.imageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType", targetDepth)) {
                    spotFleetLaunchSpecification.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("kernelId", targetDepth)) {
                    spotFleetLaunchSpecification.kernelId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("keyName", targetDepth)) {
                    spotFleetLaunchSpecification.keyName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("monitoring", targetDepth)) {
                    spotFleetLaunchSpecification.monitoring(SpotFleetMonitoringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceSet", targetDepth)) {
                    networkInterfaces = new ArrayList<InstanceNetworkInterfaceSpecification>();
                    continue;
                }

                if (context.testExpression("networkInterfaceSet/item", targetDepth)) {
                    networkInterfaces.add(InstanceNetworkInterfaceSpecificationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("placement", targetDepth)) {
                    spotFleetLaunchSpecification.placement(SpotPlacementUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ramdiskId", targetDepth)) {
                    spotFleetLaunchSpecification.ramdiskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("spotPrice", targetDepth)) {
                    spotFleetLaunchSpecification.spotPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetId", targetDepth)) {
                    spotFleetLaunchSpecification.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("userData", targetDepth)) {
                    spotFleetLaunchSpecification.userData(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("weightedCapacity", targetDepth)) {
                    spotFleetLaunchSpecification.weightedCapacity(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    spotFleetLaunchSpecification.securityGroups(securityGroups);
                    spotFleetLaunchSpecification.blockDeviceMappings(blockDeviceMappings);
                    spotFleetLaunchSpecification.networkInterfaces(networkInterfaces);
                    break;
                }
            }
        }
        return spotFleetLaunchSpecification.build();
    }

    private static final SpotFleetLaunchSpecificationUnmarshaller INSTANCE = new SpotFleetLaunchSpecificationUnmarshaller();

    public static SpotFleetLaunchSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
