/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * SubnetIpv6CidrBlockAssociation StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SubnetIpv6CidrBlockAssociationUnmarshaller implements
        Unmarshaller<SubnetIpv6CidrBlockAssociation, StaxUnmarshallerContext> {

    public SubnetIpv6CidrBlockAssociation unmarshall(StaxUnmarshallerContext context) throws Exception {
        SubnetIpv6CidrBlockAssociation.Builder subnetIpv6CidrBlockAssociation = SubnetIpv6CidrBlockAssociation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("associationId", targetDepth)) {
                    subnetIpv6CidrBlockAssociation.associationId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6CidrBlock", targetDepth)) {
                    subnetIpv6CidrBlockAssociation.ipv6CidrBlock(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6CidrBlockState", targetDepth)) {
                    subnetIpv6CidrBlockAssociation.ipv6CidrBlockState(SubnetCidrBlockStateUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return subnetIpv6CidrBlockAssociation.build();
    }

    private static final SubnetIpv6CidrBlockAssociationUnmarshaller INSTANCE = new SubnetIpv6CidrBlockAssociationUnmarshaller();

    public static SubnetIpv6CidrBlockAssociationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
