/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.waiters;

import javax.annotation.Generated;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.EC2Client;

@SdkInternalApi
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeNetworkInterfacesFunction implements
        SdkFunction<DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResponse> {

    /**
     * Represents the service client
     */
    private final EC2Client client;

    /**
     * Constructs a new DescribeNetworkInterfacesFunction with the given client
     * 
     * @param client
     *        Service client
     */
    public DescribeNetworkInterfacesFunction(EC2Client client) {
        this.client = client;
    }

    /**
     * Makes a call to the operation specified by the waiter by taking the corresponding request and returns the
     * corresponding result
     * 
     * @param describeNetworkInterfacesRequest
     *        Corresponding request for the operation
     * @return Corresponding result of the operation
     */
    @Override
    public DescribeNetworkInterfacesResponse apply(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        return client.describeNetworkInterfaces(describeNetworkInterfacesRequest);
    }
}
