/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.StaticSignerProvider;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.ec2.EC2BaseClientBuilder;

@SdkInternalApi
abstract class DefaultEC2BaseClientBuilder<B extends EC2BaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C> {
    DefaultEC2BaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "ec2";
    }

    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("software/amazon/awssdk/services/ec2/execution.interceptors").crc32FromCompressedDataEnabled(Boolean.valueOf(false)).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("ec2");
        signer.setRegionName(this.signingRegion().value());
        return new StaticSignerProvider((Signer)signer);
    }
}

